/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import org.elvior.ttcn.tritci.AbstractDecodeMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.ValueReply;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriMessage;
import org.etsi.ttcn.tri.TriStatus;

class TciDecodeMessage
extends AbstractDecodeMessage {
    public TciDecodeMessage(TriMessage message, long nTypeId) {
        super(message, nTypeId);
    }

    public TciDecodeMessage() {
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciDecodeMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.Decode;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ValueReply ack;
        ExternalTciType type = new ExternalTciType(this.getId());
        Value val = null;
        TriStatus status = TriStatusImpl.ok();
        try {
            val = TciProvider.getInstance().getTciCDProvided().decode(this.getMessage(), type);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        if (val instanceof ExternalTciValue) {
            ExternalTciValue extVal = (ExternalTciValue)val;
            ack = new ValueReply(extVal.toValueRef(), this.getMessage().getBitPosition(), 0);
        } else {
            ack = val == null ? new ValueReply(null, status.getStatus()) : new ValueReply(null, -1);
        }
        return new AdapterProcessingResult(status, ack);
    }
}

