/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciRangeBoundaryRef;
import org.elvior.ttcn.tritci.TriTciChannel;
import org.etsi.ttcn.tci.RangeBoundary;
import org.etsi.ttcn.tci.Value;

class ExternalRangeBoundary
implements RangeBoundary {
    private TciRangeBoundaryRef m_ref;

    public ExternalRangeBoundary(TciRangeBoundaryRef src) {
        this.m_ref = src;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_ref != null) {
            TriTciChannel.getInstance().unregisterTciObject(this.m_ref.getId());
        }
    }

    public TciRangeBoundaryRef toBoundaryRef() {
        return this.m_ref;
    }

    protected long getTciValueId(Value val) {
        if (val instanceof ExternalTciValue) {
            return ((ExternalTciValue)val).getId();
        }
        throw new IllegalArgumentException("Invalid TCI value format");
    }

    @Override
    public Value getBoundary() {
        return TriTciChannel.getInstance().getBoundaryValue(this.m_ref.getId());
    }

    @Override
    public void setBoundary(Value boundary, boolean isInclusive) {
        TriTciChannel.getInstance().setBoundaryValue(this.m_ref.getId(), this.getTciValueId(boundary));
        TriTciChannel.getInstance().setBoundaryInclusive(this.m_ref.getId(), isInclusive);
    }

    @Override
    public boolean isInclusive() {
        return TriTciChannel.getInstance().isBoundaryInclusive(this.m_ref.getId());
    }

    @Override
    public boolean isInfinity() {
        return TriTciChannel.getInstance().isBoundaryInfinity(this.m_ref.getId());
    }

    @Override
    public void setToInfinity() {
        TriTciChannel.getInstance().setBoundaryInfinity(this.m_ref.getId(), true);
    }
}

