package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class TestDiff_008_double {
	public static final String FOLDER = "xml/008_double";
	public static String XSD_FILE = "008_double.xsd";
	public static String FILE_1= "regression_E.xml";
	public static String FILE_2 = "regression_E_000.xml";
	public static final String FILE_base = FILE_1;
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File(FOLDER);
		differ = new XmlDiff(
				new File(root, FILE_base), 
				new String[]{XSD_FILE},
				new String[]{FOLDER});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_self() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_base));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_2() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_2));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

}
