/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.ttcn.part9.xmldiff;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogUtil {
    public final Logger logger;

    public LogUtil(Logger logger) {
        this.logger = logger;
    }

    private void _log(Level lvl, Object ... args) {
        if (!this.logger.isLoggable(lvl)) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement caller = null;
        if (trace.length > 3) {
            caller = trace[3];
        }
        if (caller != null) {
            msg.append(caller.getFileName()).append(':');
            msg.append(caller.getLineNumber()).append(':');
        }
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            msg.append(arg);
            ++n2;
        }
        LogRecord record = new LogRecord(lvl, msg.toString());
        if (caller != null) {
            record.setSourceClassName(caller.getClassName());
            record.setSourceMethodName(caller.getMethodName());
        }
        this.logger.log(record);
    }

    public void severe(Object ... args) {
        this._log(Level.SEVERE, args);
    }

    public void warning(Object ... args) {
        this._log(Level.WARNING, args);
    }

    public void config(Object ... args) {
        this._log(Level.CONFIG, args);
    }

    public void info(Object ... args) {
        this._log(Level.INFO, args);
    }

    public void debug(Object ... args) {
        this._log(Level.FINE, args);
    }

    public void debug2(Object ... args) {
        this._log(Level.FINER, args);
    }

    public void debug3(Object ... args) {
        this._log(Level.FINEST, args);
    }
}

