/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Stack;
import org.elvior.ttcn.tritci.AbstractTriAckMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.BitConverter;
import org.elvior.ttcn.tritci.BoolReply;
import org.elvior.ttcn.tritci.ByteReply;
import org.elvior.ttcn.tritci.ChannelEventHandler;
import org.elvior.ttcn.tritci.ConvertTciValueToXmlMessage;
import org.elvior.ttcn.tritci.DoubleReply;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.EnableXTriMessage;
import org.elvior.ttcn.tritci.ExternalRangeBoundary;
import org.elvior.ttcn.tritci.ExternalTciCStringValue;
import org.elvior.ttcn.tritci.ExternalTciFloatValue;
import org.elvior.ttcn.tritci.ExternalTciIntegerValue;
import org.elvior.ttcn.tritci.ExternalTciMatchingMechanism;
import org.elvior.ttcn.tritci.ExternalTciParameterList;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.ExternalTciUStringValue;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.IsMatchingSymbolMessage;
import org.elvior.ttcn.tritci.LengthRestrictionReply;
import org.elvior.ttcn.tritci.Logger;
import org.elvior.ttcn.tritci.LongIntReply;
import org.elvior.ttcn.tritci.NumericReply;
import org.elvior.ttcn.tritci.ObjidReply;
import org.elvior.ttcn.tritci.PermutationReply;
import org.elvior.ttcn.tritci.RangeBoundaryReply;
import org.elvior.ttcn.tritci.SIWriteToTCLogMessage;
import org.elvior.ttcn.tritci.SimpleStringReply;
import org.elvior.ttcn.tritci.SimpleTciObjid;
import org.elvior.ttcn.tritci.StringArrayReply;
import org.elvior.ttcn.tritci.SystemInterface;
import org.elvior.ttcn.tritci.TciAddMatchingListItemMessage;
import org.elvior.ttcn.tritci.TciAppendRecordOfItemMessage;
import org.elvior.ttcn.tritci.TciBehaviourIdImpl;
import org.elvior.ttcn.tritci.TciClassFactory;
import org.elvior.ttcn.tritci.TciClearMatchingListMessage;
import org.elvior.ttcn.tritci.TciClearPermutationsMessage;
import org.elvior.ttcn.tritci.TciDecodeMessage;
import org.elvior.ttcn.tritci.TciDefinePermutationMessage;
import org.elvior.ttcn.tritci.TciEncodeMessage;
import org.elvior.ttcn.tritci.TciErrorReqMessage;
import org.elvior.ttcn.tritci.TciGetAddressValueMessage;
import org.elvior.ttcn.tritci.TciGetBStringLengthMessage;
import org.elvior.ttcn.tritci.TciGetBStringValueMessage;
import org.elvior.ttcn.tritci.TciGetBitAtMessage;
import org.elvior.ttcn.tritci.TciGetBoolValueMessage;
import org.elvior.ttcn.tritci.TciGetBoundaryValueMessage;
import org.elvior.ttcn.tritci.TciGetCStringLengthMessage;
import org.elvior.ttcn.tritci.TciGetCStringValueMessage;
import org.elvior.ttcn.tritci.TciGetCharAtMessage;
import org.elvior.ttcn.tritci.TciGetCharValueMessage;
import org.elvior.ttcn.tritci.TciGetDecMatchContentMessage;
import org.elvior.ttcn.tritci.TciGetDefiningModule;
import org.elvior.ttcn.tritci.TciGetDefiningModuleReply;
import org.elvior.ttcn.tritci.TciGetEnumIntValueMessage;
import org.elvior.ttcn.tritci.TciGetEnumValueMessage;
import org.elvior.ttcn.tritci.TciGetFloatValueMessage;
import org.elvior.ttcn.tritci.TciGetHStringLengthMessage;
import org.elvior.ttcn.tritci.TciGetHStringValueMessage;
import org.elvior.ttcn.tritci.TciGetHexAtMessage;
import org.elvior.ttcn.tritci.TciGetImportedModules;
import org.elvior.ttcn.tritci.TciGetImportedModulesReply;
import org.elvior.ttcn.tritci.TciGetIntegerValueMessage;
import org.elvior.ttcn.tritci.TciGetLengthRestrictionMessage;
import org.elvior.ttcn.tritci.TciGetLowerRangeBoundaryMessage;
import org.elvior.ttcn.tritci.TciGetLowerTypeBoundaryMessage;
import org.elvior.ttcn.tritci.TciGetMatchingAtMessage;
import org.elvior.ttcn.tritci.TciGetMatchingListItemMessage;
import org.elvior.ttcn.tritci.TciGetMatchingListSizeMessage;
import org.elvior.ttcn.tritci.TciGetModuleParametersMessage;
import org.elvior.ttcn.tritci.TciGetModuleParametersReply;
import org.elvior.ttcn.tritci.TciGetNamedTypeMessage;
import org.elvior.ttcn.tritci.TciGetNotPresentMessage;
import org.elvior.ttcn.tritci.TciGetOStringLengthMessage;
import org.elvior.ttcn.tritci.TciGetOStringValueMessage;
import org.elvior.ttcn.tritci.TciGetObjidValueMessage;
import org.elvior.ttcn.tritci.TciGetOctetAtMessage;
import org.elvior.ttcn.tritci.TciGetPatternStringMessage;
import org.elvior.ttcn.tritci.TciGetPermutationCountMessage;
import org.elvior.ttcn.tritci.TciGetPermutationMessage;
import org.elvior.ttcn.tritci.TciGetRecordFieldNamesMessage;
import org.elvior.ttcn.tritci.TciGetRecordItemValueMessage;
import org.elvior.ttcn.tritci.TciGetRecordOfElementTypeMessage;
import org.elvior.ttcn.tritci.TciGetRecordOfItemMessage;
import org.elvior.ttcn.tritci.TciGetRecordOfLengthMessage;
import org.elvior.ttcn.tritci.TciGetRecordOfOffsetMessage;
import org.elvior.ttcn.tritci.TciGetTestCaseParamReply;
import org.elvior.ttcn.tritci.TciGetTestCaseParametersMessage;
import org.elvior.ttcn.tritci.TciGetTestCaseTsiMessage;
import org.elvior.ttcn.tritci.TciGetTestCaseTsiReply;
import org.elvior.ttcn.tritci.TciGetTestCasesMessage;
import org.elvior.ttcn.tritci.TciGetTestCasesReply;
import org.elvior.ttcn.tritci.TciGetTypeClassMessage;
import org.elvior.ttcn.tritci.TciGetTypeEncodingMessage;
import org.elvior.ttcn.tritci.TciGetTypeExtensionMessage;
import org.elvior.ttcn.tritci.TciGetTypeExtensionReply;
import org.elvior.ttcn.tritci.TciGetTypeLengthRestrictionMessage;
import org.elvior.ttcn.tritci.TciGetTypeNameMessage;
import org.elvior.ttcn.tritci.TciGetTypeVariantMessage;
import org.elvior.ttcn.tritci.TciGetUCharAtMessage;
import org.elvior.ttcn.tritci.TciGetUCharValueMessage;
import org.elvior.ttcn.tritci.TciGetUStringLengthMessage;
import org.elvior.ttcn.tritci.TciGetUStringValueMessage;
import org.elvior.ttcn.tritci.TciGetUnionItemValueMessage;
import org.elvior.ttcn.tritci.TciGetUpperRangeBoundaryMessage;
import org.elvior.ttcn.tritci.TciGetUpperTypeBoundaryMessage;
import org.elvior.ttcn.tritci.TciGetValueEncodingMessage;
import org.elvior.ttcn.tritci.TciGetValueTypeMessage;
import org.elvior.ttcn.tritci.TciGetValueVariantMessage;
import org.elvior.ttcn.tritci.TciGetVariantNamesMessage;
import org.elvior.ttcn.tritci.TciGetVerdictValueMessage;
import org.elvior.ttcn.tritci.TciIsBoundaryInclusiveMessage;
import org.elvior.ttcn.tritci.TciIsBoundaryInfinityMessage;
import org.elvior.ttcn.tritci.TciIsIfPresentEnabledMessage;
import org.elvior.ttcn.tritci.TciIsMatchingAtMessage;
import org.elvior.ttcn.tritci.TciKillConfigMessage;
import org.elvior.ttcn.tritci.TciLengthRestriction;
import org.elvior.ttcn.tritci.TciModuleIdImpl;
import org.elvior.ttcn.tritci.TciModuleIdListImpl;
import org.elvior.ttcn.tritci.TciModuleParameterIdImpl;
import org.elvior.ttcn.tritci.TciModuleParameterImpl;
import org.elvior.ttcn.tritci.TciModuleParameterListImpl;
import org.elvior.ttcn.tritci.TciNewInstanceMessage;
import org.elvior.ttcn.tritci.TciNewTemplateMessage;
import org.elvior.ttcn.tritci.TciParameterRefList;
import org.elvior.ttcn.tritci.TciPermutation;
import org.elvior.ttcn.tritci.TciPresentVariantNameMessage;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciRangeBoundaryRef;
import org.elvior.ttcn.tritci.TciRemoveMatchingListItemMessage;
import org.elvior.ttcn.tritci.TciRemovePermutationMessage;
import org.elvior.ttcn.tritci.TciRootModuleMessage;
import org.elvior.ttcn.tritci.TciSetAddressValueMessage;
import org.elvior.ttcn.tritci.TciSetBStringLengthMessage;
import org.elvior.ttcn.tritci.TciSetBStringValueMessage;
import org.elvior.ttcn.tritci.TciSetBitAtMessage;
import org.elvior.ttcn.tritci.TciSetBoolValueMessage;
import org.elvior.ttcn.tritci.TciSetBoundaryInclusiveMessage;
import org.elvior.ttcn.tritci.TciSetBoundaryInfinityMessage;
import org.elvior.ttcn.tritci.TciSetBoundaryValueMessage;
import org.elvior.ttcn.tritci.TciSetCStringLengthMessage;
import org.elvior.ttcn.tritci.TciSetCStringValueMessage;
import org.elvior.ttcn.tritci.TciSetCharAtMessage;
import org.elvior.ttcn.tritci.TciSetCharValueMessage;
import org.elvior.ttcn.tritci.TciSetDecMatchContentMessage;
import org.elvior.ttcn.tritci.TciSetEnumIntValueMessage;
import org.elvior.ttcn.tritci.TciSetEnumValueMessage;
import org.elvior.ttcn.tritci.TciSetFieldOmittedMessage;
import org.elvior.ttcn.tritci.TciSetFloatValueMessage;
import org.elvior.ttcn.tritci.TciSetHStringLengthMessage;
import org.elvior.ttcn.tritci.TciSetHStringValueMessage;
import org.elvior.ttcn.tritci.TciSetHexAtMessage;
import org.elvior.ttcn.tritci.TciSetIfPresentEnabledMessage;
import org.elvior.ttcn.tritci.TciSetIntegerValueMessage;
import org.elvior.ttcn.tritci.TciSetLengthRestrictionMessage;
import org.elvior.ttcn.tritci.TciSetLowerRangeBoundaryMessage;
import org.elvior.ttcn.tritci.TciSetMatchingAtMessage;
import org.elvior.ttcn.tritci.TciSetOStringLengthMessage;
import org.elvior.ttcn.tritci.TciSetOStringValueMessage;
import org.elvior.ttcn.tritci.TciSetObjidValueMessage;
import org.elvior.ttcn.tritci.TciSetOctetAtMessage;
import org.elvior.ttcn.tritci.TciSetPatternStringMessage;
import org.elvior.ttcn.tritci.TciSetRecordItemValueMessage;
import org.elvior.ttcn.tritci.TciSetRecordOfItemMessage;
import org.elvior.ttcn.tritci.TciSetRecordOfLengthMessage;
import org.elvior.ttcn.tritci.TciSetUCharAtMessage;
import org.elvior.ttcn.tritci.TciSetUCharValueMessage;
import org.elvior.ttcn.tritci.TciSetUStringLengthMessage;
import org.elvior.ttcn.tritci.TciSetUStringValueMessage;
import org.elvior.ttcn.tritci.TciSetUnionItemValueMessage;
import org.elvior.ttcn.tritci.TciSetUpperRangeBoundaryMessage;
import org.elvior.ttcn.tritci.TciSetVerdictValueMessage;
import org.elvior.ttcn.tritci.TciStartConfigMessage;
import org.elvior.ttcn.tritci.TciStartControlMessage;
import org.elvior.ttcn.tritci.TciStartTestCaseMessage;
import org.elvior.ttcn.tritci.TciStopControlMessage;
import org.elvior.ttcn.tritci.TciStopTestCaseMessage;
import org.elvior.ttcn.tritci.TciTestCaseIdImpl;
import org.elvior.ttcn.tritci.TciTestCaseIdListImpl;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TciValueToStringMessage;
import org.elvior.ttcn.tritci.TriAckMessage;
import org.elvior.ttcn.tritci.TriClassFactory;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriEncodedDataReply;
import org.elvior.ttcn.tritci.TriEndWaitMessage;
import org.elvior.ttcn.tritci.TriEnqueueCallMessage;
import org.elvior.ttcn.tritci.TriEnqueueExceptionMessage;
import org.elvior.ttcn.tritci.TriEnqueueMessage;
import org.elvior.ttcn.tritci.TriEnqueueReplyMessage;
import org.elvior.ttcn.tritci.TriHelloMessage;
import org.elvior.ttcn.tritci.TriMessageEx;
import org.elvior.ttcn.tritci.TriMessageReplyMessage;
import org.elvior.ttcn.tritci.TriPAErrorReqMessage;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProcessStepMessage;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriRndMessage;
import org.elvior.ttcn.tritci.TriSAErrorReqMessage;
import org.elvior.ttcn.tritci.TriSelfAckMessage;
import org.elvior.ttcn.tritci.TriSelfMessage;
import org.elvior.ttcn.tritci.TriSignatureIdImpl;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriTciCallData;
import org.elvior.ttcn.tritci.TriTciCallStack;
import org.elvior.ttcn.tritci.TriTciMessageFactory;
import org.elvior.ttcn.tritci.TriTimerIdImpl;
import org.elvior.ttcn.tritci.TriTimerTimeoutMessage;
import org.elvior.ttcn.tritci.TypeReply;
import org.elvior.ttcn.tritci.UIntReply;
import org.elvior.ttcn.tritci.UStringReply;
import org.elvior.ttcn.tritci.UnregisterTciObjectMessage;
import org.elvior.ttcn.tritci.ValueReply;
import org.elvior.ttcn.tritci.XTriEnqueueCallMessage;
import org.elvior.ttcn.tritci.XTriEnqueueExceptionMessage;
import org.elvior.ttcn.tritci.XTriEnqueueMessage;
import org.elvior.ttcn.tritci.XTriEnqueueReplyMessage;
import org.etsi.ttcn.tci.LengthRestriction;
import org.etsi.ttcn.tci.TciBehaviourId;
import org.etsi.ttcn.tci.TciCDRequired;
import org.etsi.ttcn.tci.TciModuleId;
import org.etsi.ttcn.tci.TciModuleIdList;
import org.etsi.ttcn.tci.TciModuleParameterList;
import org.etsi.ttcn.tci.TciObjId;
import org.etsi.ttcn.tci.TciParameterList;
import org.etsi.ttcn.tci.TciParameterTypeList;
import org.etsi.ttcn.tci.TciTMRequired;
import org.etsi.ttcn.tci.TciTestCaseId;
import org.etsi.ttcn.tci.TciTestCaseIdList;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriAddress;
import org.etsi.ttcn.tri.TriCommunicationTE;
import org.etsi.ttcn.tri.TriComponentId;
import org.etsi.ttcn.tri.TriException;
import org.etsi.ttcn.tri.TriMessage;
import org.etsi.ttcn.tri.TriParameter;
import org.etsi.ttcn.tri.TriParameterList;
import org.etsi.ttcn.tri.TriPlatformTE;
import org.etsi.ttcn.tri.TriPortId;
import org.etsi.ttcn.tri.TriPortIdList;
import org.etsi.ttcn.tri.TriSignatureId;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.tri.TriTimerId;
import org.etsi.ttcn.xtri.xTriCommunicationSA;
import org.etsi.ttcn.xtri.xTriCommunicationTE;
import org.etsi.ttcn.xtri.xTriPlatformPA;
import org.etsi.ttcn.xtri.xTriPlatformTE;

public final class TriTciChannel
implements TriCommunicationTE,
TriPlatformTE,
TciTMRequired,
TciCDRequired,
SystemInterface,
xTriCommunicationTE,
xTriPlatformTE {
    private static TriTciChannel s_instance = new TriTciChannel();
    private String m_sAppName;
    private ChannelEventHandler m_serviceHandler;
    private String m_sHost;
    private InetAddress m_addr;
    private int m_nPort;
    private Socket m_socket;
    private DataOutputStream m_out = null;
    private DataInputStream m_in = null;
    private TriTciCallStack m_callStack = new TriTciCallStack();
    int m_nDataOffs = 0;
    private long m_nId = 1L;
    private Stack<Long> m_unusedIds = new Stack();
    private HashMap<Long, Object> m_htRegistered = new HashMap();

    public static TriTciChannel getInstance() {
        return s_instance;
    }

    private TriTciChannel() {
        TriProvider.getInstance().setTriCommunicationTE(this);
        TriProvider.getInstance().setTriPlatformTE(this);
        TriProvider.getInstance().setTriFactory(TriClassFactory.getInstance());
        TriProvider.getInstance().setSystemInterface(this);
        TciProvider.getInstance().setTciTMRequired(this);
        TciProvider.getInstance().setTciCDRequired(this);
        TciProvider.getInstance().setTciFactory(TciClassFactory.getInstance());
        try {
            this.m_addr = InetAddress.getLocalHost();
            this.m_sHost = this.m_addr.toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.m_nPort = 7777;
    }

    public String getHost() {
        return this.m_sHost;
    }

    public void setHost(String host) throws UnknownHostException {
        this.m_addr = InetAddress.getByName(host);
        this.m_sHost = host;
    }

    public int getPort() {
        return this.m_nPort;
    }

    public void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port value");
        }
        this.m_nPort = port;
    }

    public String getApplicationName() {
        return this.m_sAppName;
    }

    public void setApplicationName(String name) {
        this.m_sAppName = name;
    }

    public ChannelEventHandler getEventHandler() {
        return this.m_serviceHandler;
    }

    public void setEventHandler(ChannelEventHandler handler) {
        this.m_serviceHandler = handler;
    }

    public boolean open() {
        return this.open(0);
    }

    public boolean open(int nMilliseconds) {
        boolean bRes = false;
        long nTargetTime = System.currentTimeMillis() + (long)nMilliseconds;
        do {
            try {
                this.m_socket = new Socket(this.m_addr, this.m_nPort);
                OutputStream rawOut = this.m_socket.getOutputStream();
                InputStream rawIn = this.m_socket.getInputStream();
                BufferedOutputStream buffOut = new BufferedOutputStream(rawOut);
                this.m_out = new DataOutputStream(buffOut);
                this.m_in = new DataInputStream(rawIn);
                bRes = true;
            }
            catch (IOException e) {
                this.onError(e.getMessage());
            }
        } while (!bRes && nTargetTime > System.currentTimeMillis());
        if (bRes) {
            byte yMode = 0;
            if (TriProvider.getInstance().getTriCommunicationSA() != null) {
                yMode = (byte)(yMode | 1);
            }
            if (TriProvider.getInstance().getTriPlatformPA() != null) {
                yMode = (byte)(yMode | 2);
            }
            if (TciProvider.getInstance().getTciTMProvided() != null) {
                yMode = (byte)(yMode | 4);
            }
            if (TciProvider.getInstance().getTciCDProvided() != null) {
                yMode = (byte)(yMode | 8);
            }
            if (TciProvider.getInstance().getTciTLProvided() != null) {
                yMode = (byte)(yMode | 0x10);
            }
            if (TciProvider.getInstance().getTciCHProvided() != null) {
                yMode = (byte)(yMode | 0x20);
            }
            if (TriProvider.getInstance().getTriCommunicationSA() instanceof xTriCommunicationSA) {
                yMode = (byte)(yMode | 0x40);
            }
            if (TriProvider.getInstance().getTriPlatformPA() instanceof xTriPlatformPA) {
                yMode = (byte)(yMode | 0xFFFFFF80);
            }
            this.writeToConnection(new TriHelloMessage(this.m_sAppName, yMode));
            if (this.m_serviceHandler != null) {
                this.m_serviceHandler.onConnectionEstablished();
            }
        }
        this.receive();
        return bRes;
    }

    public boolean enableLogging(String sFileName) {
        return Logger.getInstance().enable(sFileName);
    }

    private void receive() {
        ReceivingThread rt = new ReceivingThread(this);
        rt.start();
    }

    private int receiveBytes(byte[] ayMessage, int nLen) throws IOException {
        int nReceived;
        int nOffset = 0;
        while ((nReceived = this.m_in.read(ayMessage, nOffset, nLen)) > 0) {
            nOffset += nReceived;
            nLen -= nReceived;
        }
        return nReceived < 0 ? -1 : nOffset;
    }

    private void receiveProc() {
        if (this.shouldExit()) {
            return;
        }
        byte[] ayHdr = new byte[9];
        try {
            int nBytes = this.receiveBytes(ayHdr, 9);
            if (nBytes < 0) {
                this.stop();
                return;
            }
        }
        catch (IOException e) {
            this.onError(e.getMessage());
            return;
        }
        byte yVersion = ayHdr[0];
        if (yVersion == -128) {
            int nMsgCode = BitConverter.toInt(ayHdr, 1);
            int nLen = BitConverter.toInt(ayHdr, 5);
            if (nLen > 0x1000000 || nLen < 0) {
                this.onError(String.format("Invalid data length: {0}", nLen));
            } else if (nLen == 0) {
                this.receive();
                byte[] ayMessage = new byte[]{};
                this.onMessageReceived(nMsgCode, ayMessage);
            } else {
                byte[] ayMessage = new byte[nLen];
                try {
                    int nBytes = this.receiveBytes(ayMessage, nLen);
                    if (nBytes < 0) {
                        this.stop();
                        return;
                    }
                }
                catch (IOException e) {
                    this.onError(e.getMessage());
                }
                this.receive();
                this.onMessageReceived(nMsgCode, ayMessage);
            }
        } else {
            this.onError("Invalid protocol format");
        }
    }

    private void onMessageReceived(int nMsg, byte[] ayMessage) {
        AbstractTriTciMessage msg = null;
        try {
            msg = TriTciMessageFactory.getInstance().createMessage(nMsg);
        }
        catch (Exception e) {
            this.onError(e.getMessage());
        }
        if (msg == null) {
            this.onError("Unknown message received from the TE");
            return;
        }
        ByteArrayInputStream ms = new ByteArrayInputStream(ayMessage);
        if (!msg.deserialize(ms)) {
            this.onError("The " + msg.getMessageName() + " message has an incorrect format");
        }
        if (this.m_callStack.acceptMessage(msg)) {
            return;
        }
        TriStatus status = TriStatusImpl.error();
        AbstractTriAckMessage ack = null;
        int nLocalId = this.m_callStack.saveCommunicationIDs(msg, false);
        try {
            if (!msg.isSupportedInAdapter()) {
                this.onError(String.valueOf(msg.getMessageName()) + " message is not supported by the TRI/TCI plugin");
                this.m_callStack.updateThreadId(nLocalId);
                this.m_callStack.releaseBlockedLocalId(nLocalId);
                return;
            }
            AdapterProcessingResult res = msg.processInAdapter();
            status = res.getStatus();
            if (status == null) {
                this.onError(String.valueOf(msg.getMessageName()) + " message not processed correctly by SA: returned status is null");
                status = TriStatusImpl.error();
                return;
            }
            ack = res.getAck();
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        if (ack == null) {
            ack = new TriAckMessage(status.getStatus());
        }
        if (ack instanceof ValueReply) {
            this.m_callStack.fillCommunicationIds(ack, false, true, nLocalId);
            int nStackSize = this.m_callStack.getStackSize(ack.getClientChannelId());
            this.writeToConnection(ack, ETriTciMessageCode.Ack, true, false);
            this.m_callStack.updateThreadId(ack.getClientChannelId());
            if (nStackSize == 0) {
                this.m_callStack.releaseBlockedLocalId(ack.getClientChannelId());
            }
        } else {
            this.m_callStack.fillCommunicationIds(ack, false, true, nLocalId);
            int nStackSize = this.m_callStack.getStackSize(ack.getClientChannelId());
            this.writeToConnection(ack);
            if (nStackSize == 0) {
                this.m_callStack.releaseBlockedLocalId(ack.getClientChannelId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldExit() {
        boolean bRes = false;
        boolean bClose = false;
        TriTciChannel triTciChannel = this;
        synchronized (triTciChannel) {
            bRes = this.m_socket == null || !this.m_socket.isConnected();
            bClose = this.m_socket != null && !this.m_socket.isConnected();
        }
        if (bClose) {
            this.stop();
        }
        return bRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanObjectRegister() {
        TriTciChannel triTciChannel = this;
        synchronized (triTciChannel) {
            this.m_unusedIds.clear();
            this.m_htRegistered.clear();
            this.m_nId = 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean bNotify = false;
        Logger.getInstance().close();
        TriTciChannel triTciChannel = this;
        synchronized (triTciChannel) {
            bNotify = this.m_socket != null;
            if (bNotify) {
                Socket tmpSock = this.m_socket;
                this.m_socket = null;
                try {
                    this.m_in.close();
                    this.m_out.close();
                    tmpSock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_callStack.clear();
                this.cleanObjectRegister();
            }
        }
        if (bNotify && this.m_serviceHandler != null) {
            this.m_serviceHandler.onConnectionClosed();
        }
    }

    private AbstractTriAckMessage writeToConnection(AbstractTriTciMessage msg, ETriTciMessageCode requiredAck, boolean bThrowOnError) {
        return this.writeToConnection(msg, requiredAck, bThrowOnError, true);
    }

    private AbstractTriAckMessage writeToConnection(AbstractTriTciMessage msg, ETriTciMessageCode requiredAck, boolean bThrowOnError, boolean bFill) {
        if (this.shouldExit()) {
            return null;
        }
        TriTciCallData callData = this.m_callStack.registerCall(msg, requiredAck, 50000, false, bFill);
        this.writeToConnection(msg);
        AbstractTriAckMessage res = callData.waitForAck();
        if (res == null) {
            this.m_callStack.unregisterCall();
            this.onError(String.valueOf(msg.getMessageName()) + " operation timeout, no response from the TE");
        } else if (bThrowOnError && res.getStatus() == -1) {
            throw new RuntimeException("Critical error in a TRI/TCI operation");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToConnection(AbstractTriTciMessage msg) {
        if (this.shouldExit()) {
            return;
        }
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        msg.serialize(ms);
        try {
            ms.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] aData = ms.toByteArray();
        int nLen = aData != null ? aData.length : 0;
        TriTciChannel triTciChannel = this;
        synchronized (triTciChannel) {
            try {
                this.m_out.writeByte(128);
                this.m_out.write(BitConverter.getBytes(msg.getMessageCode().ordinal()));
                this.m_out.write(BitConverter.getBytes(nLen));
                this.m_out.write(aData);
                this.m_out.flush();
            }
            catch (IOException e) {
                this.onError(e.getMessage());
            }
        }
    }

    private void onError(String sError) {
        if (this.m_serviceHandler != null) {
            this.m_serviceHandler.onError(sError);
        }
        this.stop();
    }

    @Override
    public void triEnqueueCall(TriPortId tsiPortId, TriAddress SUTaddress, TriComponentId componentId, TriSignatureId signatureId, TriParameterList parameterList) {
        TriEnqueueCallMessage toSend = new TriEnqueueCallMessage(componentId, tsiPortId, SUTaddress, signatureId, parameterList);
        this.writeToConnection(toSend);
    }

    @Override
    public void triEnqueueException(TriPortId tsiPortId, TriAddress sutAddress, TriComponentId componentId, TriSignatureId signatureId, TriException exc) {
        TriEnqueueExceptionMessage toSend = new TriEnqueueExceptionMessage(componentId, tsiPortId, sutAddress, signatureId, exc);
        this.writeToConnection(toSend);
    }

    @Override
    public void triEnqueueMsg(TriPortId tsiPortId, TriAddress sutAddress, TriComponentId componentId, TriMessage receivedMessage) {
        TriEnqueueMessage toSend = new TriEnqueueMessage(tsiPortId, sutAddress, componentId, receivedMessage);
        this.writeToConnection(toSend);
    }

    @Override
    public void triEnqueueReply(TriPortId tsiPortId, TriAddress address, TriComponentId componentId, TriSignatureId signatureId, TriParameterList parameterList, TriParameter returnValue) {
        TriEnqueueReplyMessage toSend = new TriEnqueueReplyMessage(componentId, tsiPortId, address, signatureId, parameterList, returnValue);
        this.writeToConnection(toSend);
    }

    @Override
    public void triTimeout(TriTimerId timerId) {
        TriTimerTimeoutMessage msg = new TriTimerTimeoutMessage((TriTimerIdImpl)timerId);
        this.writeToConnection(msg);
    }

    TciModuleIdImpl getDefiningModule(long nId) {
        TciGetDefiningModule msg = new TciGetDefiningModule(nId);
        TciGetDefiningModuleReply reply = (TciGetDefiningModuleReply)this.writeToConnection(msg, ETriTciMessageCode.GetDefiningModuleReply, true);
        if (reply != null) {
            return reply.getModuleId();
        }
        return null;
    }

    String getTciTypeName(long nId) {
        TciGetTypeNameMessage msg = new TciGetTypeNameMessage(nId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    int getTypeClass(long nId) {
        TciGetTypeClassMessage msg = new TciGetTypeClassMessage(nId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    ExternalTciValue createTciTypeInstance(long nId) {
        TciNewInstanceMessage msg = new TciNewInstanceMessage(nId);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    ExternalTciMatchingMechanism createTciTemplate(long nId, int matchingType) {
        TciNewTemplateMessage msg = new TciNewTemplateMessage(nId, matchingType);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue(matchingType);
        }
        return null;
    }

    String getTypeEncoding(long nId) {
        TciGetTypeEncodingMessage msg = new TciGetTypeEncodingMessage(nId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    String getTypeVariant(long nId) {
        TciGetTypeVariantMessage msg = new TciGetTypeVariantMessage(nId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    String[] getTypeExtension(long nId) {
        TciGetTypeExtensionMessage msg = new TciGetTypeExtensionMessage(nId);
        TciGetTypeExtensionReply reply = (TciGetTypeExtensionReply)this.writeToConnection(msg, ETriTciMessageCode.GetTypeExtensionReply, true);
        if (reply != null) {
            return reply.getValues();
        }
        return null;
    }

    void unregisterTciObject(long nId) {
        UnregisterTciObjectMessage msg = new UnregisterTciObjectMessage(nId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, false);
    }

    ExternalTciType getValueType(long nValueId) {
        TciGetValueTypeMessage msg = new TciGetValueTypeMessage(nValueId);
        TypeReply reply = (TypeReply)this.writeToConnection(msg, ETriTciMessageCode.TypeReply, true);
        if (reply != null) {
            return reply.createType();
        }
        return null;
    }

    boolean getNotPresent(long nValueId) {
        TciGetNotPresentMessage msg = new TciGetNotPresentMessage(nValueId);
        BoolReply reply = (BoolReply)this.writeToConnection(msg, ETriTciMessageCode.BoolReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return true;
    }

    String getValueEncoding(long nValueId) {
        TciGetValueEncodingMessage msg = new TciGetValueEncodingMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    String getValueVariant(long nValueId) {
        TciGetValueVariantMessage msg = new TciGetValueVariantMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    String valueToString(long nValueId) {
        TciValueToStringMessage msg = new TciValueToStringMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    TciLengthRestriction getLengthRestriction(long nValueId) {
        TciGetLengthRestrictionMessage msg = new TciGetLengthRestrictionMessage(nValueId);
        LengthRestrictionReply reply = (LengthRestrictionReply)this.writeToConnection(msg, ETriTciMessageCode.LenRestrictionReply, true);
        if (reply != null) {
            return reply.getLengthRestriction();
        }
        return null;
    }

    void setLengthRestriction(long nValueId, LengthRestriction restriction) {
        TciLengthRestriction lr = null;
        if (restriction instanceof TciLengthRestriction) {
            lr = (TciLengthRestriction)restriction;
        }
        if (lr == null && restriction != null) {
            lr = new TciLengthRestriction(restriction);
        }
        TciSetLengthRestrictionMessage msg = new TciSetLengthRestrictionMessage(nValueId, lr);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    boolean isIfPresentEnabled(long nValueId) {
        TciIsIfPresentEnabledMessage msg = new TciIsIfPresentEnabledMessage(nValueId);
        BoolReply reply = (BoolReply)this.writeToConnection(msg, ETriTciMessageCode.BoolReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return false;
    }

    void setIfPresentEnabled(long nValueId, boolean bEnable) {
        TciSetIfPresentEnabledMessage msg = new TciSetIfPresentEnabledMessage(nValueId, bEnable);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    long getIntegerValue(long nValueId) {
        TciGetIntegerValueMessage msg = new TciGetIntegerValueMessage(nValueId);
        LongIntReply reply = (LongIntReply)this.writeToConnection(msg, ETriTciMessageCode.LongIntReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0L;
    }

    void setIntegerValue(long nValueId, long nVal) {
        TciSetIntegerValueMessage msg = new TciSetIntegerValueMessage(nValueId, nVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    double getFloatValue(long nValueId) {
        TciGetFloatValueMessage msg = new TciGetFloatValueMessage(nValueId);
        DoubleReply reply = (DoubleReply)this.writeToConnection(msg, ETriTciMessageCode.DoubleReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0.0;
    }

    void setFloatValue(long nValueId, double fVal) {
        TciSetFloatValueMessage msg = new TciSetFloatValueMessage(nValueId, fVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    boolean getBoolValue(long nValueId) {
        TciGetBoolValueMessage msg = new TciGetBoolValueMessage(nValueId);
        BoolReply reply = (BoolReply)this.writeToConnection(msg, ETriTciMessageCode.BoolReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return false;
    }

    void setBoolValue(long nValueId, boolean bVal) {
        TciSetBoolValueMessage msg = new TciSetBoolValueMessage(nValueId, bVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    char getCharValue(long nValueId) {
        TciGetCharValueMessage msg = new TciGetCharValueMessage(nValueId);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, true);
        if (reply != null) {
            return (char)reply.getValue();
        }
        return '\u0000';
    }

    void setCharValue(long nValueId, char cVal) {
        TciSetCharValueMessage msg = new TciSetCharValueMessage(nValueId, cVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String getCStringValue(long nValueId) {
        TciGetCStringValueMessage msg = new TciGetCStringValueMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    void setCStringValue(long nValueId, String sVal) {
        TciSetCStringValueMessage msg = new TciSetCStringValueMessage(nValueId, sVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    char getCharAt(long nValueId, int nIndex) {
        TciGetCharAtMessage msg = new TciGetCharAtMessage(nValueId, nIndex);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, true);
        if (reply != null) {
            return (char)reply.getValue();
        }
        return '\u0000';
    }

    void setCharAt(long nValueId, char c, int nIndex) {
        TciSetCharAtMessage msg = new TciSetCharAtMessage(nValueId, c, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getCStringLength(long nValueId) {
        TciGetCStringLengthMessage msg = new TciGetCStringLengthMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    void setCStringLength(long nValueId, int nLength) {
        TciSetCStringLengthMessage msg = new TciSetCStringLengthMessage(nValueId, nLength);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String getBStringValue(long nValueId) {
        TciGetBStringValueMessage msg = new TciGetBStringValueMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    void setBStringValue(long nValueId, String sVal) {
        TciSetBStringValueMessage msg = new TciSetBStringValueMessage(nValueId, sVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    byte getBitAt(long nValueId, int nIndex) {
        TciGetBitAtMessage msg = new TciGetBitAtMessage(nValueId, nIndex);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    void setBitAt(long nValueId, byte yVal, int nIndex) {
        TciSetBitAtMessage msg = new TciSetBitAtMessage(nValueId, yVal, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getBStringLength(long nValueId) {
        TciGetBStringLengthMessage msg = new TciGetBStringLengthMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    void setBStringLength(long nValueId, int nLength) {
        TciSetBStringLengthMessage msg = new TciSetBStringLengthMessage(nValueId, nLength);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    boolean isMatchinAt(long nValueId, int nIndex, int requiredType) {
        TciIsMatchingAtMessage msg = new TciIsMatchingAtMessage(nValueId, nIndex, requiredType);
        BoolReply reply = (BoolReply)this.writeToConnection(msg, ETriTciMessageCode.BoolReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return false;
    }

    ExternalTciMatchingMechanism getMatchingAt(long nValueId, int nIndex, int requiredType) {
        TciGetMatchingAtMessage msg = new TciGetMatchingAtMessage(nValueId, nIndex, requiredType);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return (ExternalTciMatchingMechanism)reply.createValue();
        }
        return null;
    }

    void setMatchingAt(long nValueId, int nIndex, long nItemId, int requiredType) {
        TciSetMatchingAtMessage msg = new TciSetMatchingAtMessage(nValueId, nItemId, nIndex, requiredType);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String getHStringValue(long nValueId) {
        TciGetHStringValueMessage msg = new TciGetHStringValueMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    void setHStringValue(long nValueId, String sVal) {
        TciSetHStringValueMessage msg = new TciSetHStringValueMessage(nValueId, sVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    byte getHexAt(long nValueId, int nIndex) {
        TciGetHexAtMessage msg = new TciGetHexAtMessage(nValueId, nIndex);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    void setHexAt(long nValueId, byte yVal, int nIndex) {
        TciSetHexAtMessage msg = new TciSetHexAtMessage(nValueId, yVal, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getHStringLength(long nValueId) {
        TciGetHStringLengthMessage msg = new TciGetHStringLengthMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    void setHStringLength(long nValueId, int nLength) {
        TciSetHStringLengthMessage msg = new TciSetHStringLengthMessage(nValueId, nLength);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String getOStringValue(long nValueId) {
        TciGetOStringValueMessage msg = new TciGetOStringValueMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    void setOStringValue(long nValueId, String sVal) {
        TciSetOStringValueMessage msg = new TciSetOStringValueMessage(nValueId, sVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    byte getOctetAt(long nValueId, int nIndex) {
        TciGetOctetAtMessage msg = new TciGetOctetAtMessage(nValueId, nIndex);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    void setOctetAt(long nValueId, byte yVal, int nIndex) {
        TciSetOctetAtMessage msg = new TciSetOctetAtMessage(nValueId, yVal, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getOStringLength(long nValueId) {
        TciGetOStringLengthMessage msg = new TciGetOStringLengthMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    void setOStringLength(long nValueId, int nLength) {
        TciSetOStringLengthMessage msg = new TciSetOStringLengthMessage(nValueId, nLength);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getUCharValue(long nValueId) {
        TciGetUCharValueMessage msg = new TciGetUCharValueMessage(nValueId);
        UIntReply reply = (UIntReply)this.writeToConnection(msg, ETriTciMessageCode.UIntReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    void setUCharValue(long nValueId, int nVal) {
        TciSetUCharValueMessage msg = new TciSetUCharValueMessage(nValueId, nVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String getUStringValue(long nValueId) {
        TciGetUStringValueMessage msg = new TciGetUStringValueMessage(nValueId);
        UStringReply reply = (UStringReply)this.writeToConnection(msg, ETriTciMessageCode.UStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    void setUStringValue(long nValueId, String sVal) {
        TciSetUStringValueMessage msg = new TciSetUStringValueMessage(nValueId, sVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getUCharAt(long nValueId, int nIndex) {
        TciGetUCharAtMessage msg = new TciGetUCharAtMessage(nValueId, nIndex);
        UIntReply reply = (UIntReply)this.writeToConnection(msg, ETriTciMessageCode.UIntReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    void setUCharAt(long nValueId, int nVal, int nIndex) {
        TciSetUCharAtMessage msg = new TciSetUCharAtMessage(nValueId, nVal, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getUStringLength(long nValueId) {
        TciGetUStringLengthMessage msg = new TciGetUStringLengthMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    void setUStringLength(long nValueId, int nLength) {
        TciSetUStringLengthMessage msg = new TciSetUStringLengthMessage(nValueId, nLength);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String getEnumValue(long nValueId) {
        TciGetEnumValueMessage msg = new TciGetEnumValueMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    void setEnumValue(long nValueId, String sVal) {
        TciSetEnumValueMessage msg = new TciSetEnumValueMessage(nValueId, sVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getEnumIntValue(long nValueId) {
        TciGetEnumIntValueMessage msg = new TciGetEnumIntValueMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    void setEnumIntValue(long nValueId, int nVal) {
        TciSetEnumIntValueMessage msg = new TciSetEnumIntValueMessage(nValueId, nVal);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getVerdictValue(long nValueId) {
        TciGetVerdictValueMessage msg = new TciGetVerdictValueMessage(nValueId);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 4;
    }

    void setVerdictValue(long nValueId, int nVerdict) {
        TciSetVerdictValueMessage msg = new TciSetVerdictValueMessage(nValueId, nVerdict);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciValue getRecordItemValue(long nValueId, String sItemName) {
        TciGetRecordItemValueMessage msg = new TciGetRecordItemValueMessage(nValueId, sItemName);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setRecordItemValue(long nValueId, String sItemName, long nItemId) {
        TciSetRecordItemValueMessage msg = new TciSetRecordItemValueMessage(nValueId, sItemName, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String[] getRecordFieldNames(long nValueId) {
        TciGetRecordFieldNamesMessage msg = new TciGetRecordFieldNamesMessage(nValueId);
        StringArrayReply reply = (StringArrayReply)this.writeToConnection(msg, ETriTciMessageCode.StringArrayReply, true);
        if (reply != null) {
            return reply.getValues();
        }
        return null;
    }

    void setFieldOmitted(long nValueId, String sItemName) {
        TciSetFieldOmittedMessage msg = new TciSetFieldOmittedMessage(nValueId, sItemName);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciValue getUnionItemValue(long nValueId, String sItemName) {
        TciGetUnionItemValueMessage msg = new TciGetUnionItemValueMessage(nValueId, sItemName);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setUnionItemValue(long nValueId, String sItemName, long nItemId) {
        TciSetUnionItemValueMessage msg = new TciSetUnionItemValueMessage(nValueId, sItemName, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    String[] getVariantNames(long nValueId) {
        TciGetVariantNamesMessage msg = new TciGetVariantNamesMessage(nValueId);
        StringArrayReply reply = (StringArrayReply)this.writeToConnection(msg, ETriTciMessageCode.StringArrayReply, true);
        if (reply != null) {
            return reply.getValues();
        }
        return null;
    }

    String getPresentVariant(long nValueId) {
        TciPresentVariantNameMessage msg = new TciPresentVariantNameMessage(nValueId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    ExternalTciValue getRecordOfItemAt(long nRecordOfId, int nIndex) {
        TciGetRecordOfItemMessage msg = new TciGetRecordOfItemMessage(nRecordOfId, nIndex);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setRecordOfItemAt(long nRecordOfId, long nItemId, int nIndex) {
        TciSetRecordOfItemMessage msg = new TciSetRecordOfItemMessage(nRecordOfId, nItemId, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    void appendRecordOfField(long nRecordOfId, long nItemId) {
        TciAppendRecordOfItemMessage msg = new TciAppendRecordOfItemMessage(nRecordOfId, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciType getRecordOfElementType(long nRecordOfId) {
        TciGetRecordOfElementTypeMessage msg = new TciGetRecordOfElementTypeMessage(nRecordOfId);
        TypeReply reply = (TypeReply)this.writeToConnection(msg, ETriTciMessageCode.TypeReply, true);
        if (reply != null) {
            return reply.createType();
        }
        return null;
    }

    int getRecordOfLength(long nRecordOfId) {
        TciGetRecordOfLengthMessage msg = new TciGetRecordOfLengthMessage(nRecordOfId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    void setRecordOfLength(long nRecordOfId, int nLength) {
        TciSetRecordOfLengthMessage msg = new TciSetRecordOfLengthMessage(nRecordOfId, nLength);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getRecordOfOffset(long nRecordOfId) {
        TciGetRecordOfOffsetMessage msg = new TciGetRecordOfOffsetMessage(nRecordOfId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    int getPermutationCount(long nRecordOfId) {
        TciGetPermutationCountMessage msg = new TciGetPermutationCountMessage(nRecordOfId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return 0;
    }

    TciPermutation getPermutation(long nRecordOfId, int nIndex) {
        TciGetPermutationMessage msg = new TciGetPermutationMessage(nRecordOfId, nIndex);
        PermutationReply reply = (PermutationReply)this.writeToConnection(msg, ETriTciMessageCode.PermutationReply, true);
        if (reply != null) {
            return reply.getPermutation();
        }
        return null;
    }

    void definePermutation(long nRecordOfId, TciPermutation perm) {
        TciDefinePermutationMessage msg = new TciDefinePermutationMessage(nRecordOfId, perm);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    void removePermutation(long nRecordOfId, int nIndex) {
        TciRemovePermutationMessage msg = new TciRemovePermutationMessage(nRecordOfId, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    void clearPermutations(long nRecordOfId) {
        TciClearPermutationsMessage msg = new TciClearPermutationsMessage(nRecordOfId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciValue getAddressValue(long nValueId) {
        TciGetAddressValueMessage msg = new TciGetAddressValueMessage(nValueId);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setAddressValue(long nValueId, long nAddressId) {
        TciSetAddressValueMessage msg = new TciSetAddressValueMessage(nValueId, nAddressId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    SimpleTciObjid getObjidValue(long nValueId) {
        TciGetObjidValueMessage msg = new TciGetObjidValueMessage(nValueId);
        ObjidReply reply = (ObjidReply)this.writeToConnection(msg, ETriTciMessageCode.ObjidReply, true);
        if (reply != null) {
            return reply.getObjId();
        }
        return null;
    }

    void setObjidValue(long nValueId, TciObjId objid) {
        if (objid == null) {
            throw new NullPointerException();
        }
        SimpleTciObjid tmp = objid instanceof SimpleTciObjid ? (SimpleTciObjid)objid : new SimpleTciObjid(objid);
        TciSetObjidValueMessage msg = new TciSetObjidValueMessage(nValueId, tmp);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    int getMatchingListSize(long nValueId) {
        TciGetMatchingListSizeMessage msg = new TciGetMatchingListSizeMessage(nValueId);
        NumericReply reply = (NumericReply)this.writeToConnection(msg, ETriTciMessageCode.NumericReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return -1;
    }

    ExternalTciValue getMatchingListItemAt(long nValueId, int nIndex) {
        TciGetMatchingListItemMessage msg = new TciGetMatchingListItemMessage(nValueId, nIndex);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void addMatchingListItem(long nValueId, long nItemId) {
        TciAddMatchingListItemMessage msg = new TciAddMatchingListItemMessage(nValueId, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    void removeMatchingListItemAt(long nValueId, int nIndex) {
        TciRemoveMatchingListItemMessage msg = new TciRemoveMatchingListItemMessage(nValueId, nIndex);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    void clearMatchingList(long nValueId) {
        TciClearMatchingListMessage msg = new TciClearMatchingListMessage(nValueId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciValue getPatternString(long nValueId) {
        TciGetPatternStringMessage msg = new TciGetPatternStringMessage(nValueId);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setPatternString(long nValueId, long nItemId) {
        TciSetPatternStringMessage msg = new TciSetPatternStringMessage(nValueId, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciValue getDecMatchContent(long nValueId) {
        TciGetDecMatchContentMessage msg = new TciGetDecMatchContentMessage(nValueId);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setDecMatchContent(long nValueId, long nItemId) {
        TciSetDecMatchContentMessage msg = new TciSetDecMatchContentMessage(nValueId, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalTciValue getBoundaryValue(long nValueId) {
        TciGetBoundaryValueMessage msg = new TciGetBoundaryValueMessage(nValueId);
        ValueReply reply = (ValueReply)this.writeToConnection(msg, ETriTciMessageCode.ValueReply, true);
        if (reply != null) {
            return reply.createValue();
        }
        return null;
    }

    void setBoundaryValue(long nValueId, long nItemId) {
        TciSetBoundaryValueMessage msg = new TciSetBoundaryValueMessage(nValueId, nItemId);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    boolean isBoundaryInclusive(long nValueId) {
        TciIsBoundaryInclusiveMessage msg = new TciIsBoundaryInclusiveMessage(nValueId);
        BoolReply reply = (BoolReply)this.writeToConnection(msg, ETriTciMessageCode.BoolReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return true;
    }

    void setBoundaryInclusive(long nValueId, boolean bInclusive) {
        TciSetBoundaryInclusiveMessage msg = new TciSetBoundaryInclusiveMessage(nValueId, bInclusive);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    boolean isBoundaryInfinity(long nValueId) {
        TciIsBoundaryInfinityMessage msg = new TciIsBoundaryInfinityMessage(nValueId);
        BoolReply reply = (BoolReply)this.writeToConnection(msg, ETriTciMessageCode.BoolReply, true);
        if (reply != null) {
            return reply.getValue();
        }
        return true;
    }

    void setBoundaryInfinity(long nValueId, boolean bInfinity) {
        TciSetBoundaryInfinityMessage msg = new TciSetBoundaryInfinityMessage(nValueId, bInfinity);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalRangeBoundary getLowerRangeBoundary(long nId) {
        TciGetLowerRangeBoundaryMessage msg = new TciGetLowerRangeBoundaryMessage(nId);
        RangeBoundaryReply reply = (RangeBoundaryReply)this.writeToConnection(msg, ETriTciMessageCode.RangeBoundaryReply, false);
        if (reply != null) {
            return reply.createBoundary();
        }
        return null;
    }

    void setLowerRangeBoundary(long nValueId, TciRangeBoundaryRef boundaryRef) {
        TciSetLowerRangeBoundaryMessage msg = new TciSetLowerRangeBoundaryMessage(nValueId, boundaryRef);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    ExternalRangeBoundary getUpperRangeBoundary(long nId) {
        TciGetUpperRangeBoundaryMessage msg = new TciGetUpperRangeBoundaryMessage(nId);
        RangeBoundaryReply reply = (RangeBoundaryReply)this.writeToConnection(msg, ETriTciMessageCode.RangeBoundaryReply, false);
        if (reply != null) {
            return reply.createBoundary();
        }
        return null;
    }

    void setUpperRangeBoundary(long nValueId, TciRangeBoundaryRef boundaryRef) {
        TciSetUpperRangeBoundaryMessage msg = new TciSetUpperRangeBoundaryMessage(nValueId, boundaryRef);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public TciModuleIdList tciGetImportedModules() {
        TciGetImportedModules msg = new TciGetImportedModules();
        TciGetImportedModulesReply ack = (TciGetImportedModulesReply)this.writeToConnection(msg, ETriTciMessageCode.GetImportedModulesReply, true);
        TciModuleIdListImpl res = null;
        if (ack != null) {
            res = ack.getModuleIdList();
        }
        return res;
    }

    @Override
    public TciModuleParameterList tciGetModuleParameters(TciModuleId moduleId) {
        TciGetModuleParametersMessage msg;
        TciGetModuleParametersReply reply;
        String sModuleName = moduleId.getModuleName();
        if (sModuleName == null) {
            sModuleName = moduleId.getBaseName();
        }
        if ((reply = (TciGetModuleParametersReply)this.writeToConnection(msg = new TciGetModuleParametersMessage(sModuleName), ETriTciMessageCode.GetModuleParametersReply, true)) != null) {
            TciModuleParameterIdImpl[] aParamNames = reply.getParameterNames();
            if (aParamNames == null) {
                return null;
            }
            TciValueRef[] aRef = reply.getValueReferences();
            TciModuleParameterListImpl res = new TciModuleParameterListImpl();
            int i = 0;
            while (i < aParamNames.length) {
                ExternalTciValue val = null;
                if (aRef[i] != null) {
                    val = aRef[i].createValue();
                }
                TciModuleParameterImpl param = new TciModuleParameterImpl(aParamNames[i].getBaseName(), val);
                res.add(param);
                ++i;
            }
            return res;
        }
        return null;
    }

    @Override
    public TciParameterTypeList tciGetTestCaseParameters(TciTestCaseId testCaseId) {
        TciGetTestCaseParametersMessage msg = new TciGetTestCaseParametersMessage(testCaseId);
        TciGetTestCaseParamReply reply = (TciGetTestCaseParamReply)this.writeToConnection(msg, ETriTciMessageCode.GetTestCaseParamReply, true);
        if (reply != null) {
            return reply.getParams();
        }
        return null;
    }

    @Override
    public TriPortIdList tciGetTestCaseTSI(TciTestCaseId testCaseId) {
        TciGetTestCaseTsiMessage msg = new TciGetTestCaseTsiMessage(testCaseId);
        TciGetTestCaseTsiReply reply = (TciGetTestCaseTsiReply)this.writeToConnection(msg, ETriTciMessageCode.GetTestCaseTsiReply, true);
        if (reply != null) {
            return reply.getPorts();
        }
        return null;
    }

    @Override
    public TciTestCaseIdList tciGetTestCases() {
        TciGetTestCasesMessage msg = new TciGetTestCasesMessage();
        TciGetTestCasesReply ack = (TciGetTestCasesReply)this.writeToConnection(msg, ETriTciMessageCode.GetTestCasesReply, true);
        TciTestCaseIdListImpl res = null;
        if (ack != null) {
            res = ack.getTestCaseList();
        }
        return res;
    }

    @Override
    public void tciRootModule(TciModuleId moduleName) {
        String sModuleName = moduleName.getModuleName();
        if (sModuleName == null) {
            sModuleName = moduleName.getBaseName();
        }
        TciRootModuleMessage msg = new TciRootModuleMessage(sModuleName);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public TriComponentId tciStartControl() {
        TciStartControlMessage msg = new TciStartControlMessage();
        TriAckMessage ack = (TriAckMessage)this.writeToConnection(msg, ETriTciMessageCode.Ack, false);
        if (ack != null && ack.getStatus() == 0) {
            return TriComponentIdImpl.getControl();
        }
        return null;
    }

    @Override
    public void tciStartTestCase(String testCaseId, TciParameterList parameterList) {
        TciParameterRefList list = null;
        if (parameterList != null) {
            if (parameterList instanceof ExternalTciParameterList) {
                list = ((ExternalTciParameterList)parameterList).toParameterRefList();
            } else {
                throw new IllegalArgumentException("Parameter list was not created by MM");
            }
        }
        TciTestCaseIdImpl tcId = new TciTestCaseIdImpl(testCaseId);
        TciStartTestCaseMessage msg = new TciStartTestCaseMessage(tcId, list);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void tciStopControl() {
        TciStopTestCaseMessage msg = new TciStopTestCaseMessage();
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void tciStopTestCase() {
        TciStopControlMessage msg = new TciStopControlMessage();
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void tciStartConfig(TciBehaviourId configId, TciParameterList parameterList) {
        TciParameterRefList list = null;
        if (parameterList != null) {
            if (parameterList instanceof ExternalTciParameterList) {
                list = ((ExternalTciParameterList)parameterList).toParameterRefList();
            } else {
                throw new IllegalArgumentException("Parameter list was not created by MM");
            }
        }
        TciBehaviourIdImpl cId = new TciBehaviourIdImpl(configId.getModuleName(), configId.getBaseName());
        TciStartConfigMessage msg = new TciStartConfigMessage(cId, list);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void tciKillConfig(Value ref) {
        ExternalTciValue tciVal = (ExternalTciValue)ref;
        TciKillConfigMessage msg = new TciKillConfigMessage(tciVal.toValueRef());
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public Type getBitstring() {
        return this.getTypeForName("bitstring");
    }

    @Override
    public Type getBoolean() {
        return this.getTypeForName("boolean");
    }

    @Override
    public Type getCharstring() {
        return this.getTypeForName("charstring");
    }

    @Override
    public Type getFloat() {
        return this.getTypeForName("float");
    }

    @Override
    public Type getHexstring() {
        return this.getTypeForName("hexstring");
    }

    @Override
    public Type getInteger() {
        return this.getTypeForName("integer");
    }

    @Override
    public Type getOctetstring() {
        return this.getTypeForName("octetstring");
    }

    @Override
    public Type getTypeForName(String typeName) {
        TciGetNamedTypeMessage msg = new TciGetNamedTypeMessage(typeName);
        TypeReply reply = (TypeReply)this.writeToConnection(msg, ETriTciMessageCode.TypeReply, false);
        if (reply != null) {
            return reply.createType();
        }
        return null;
    }

    @Override
    public Type getUniversalCharstring() {
        return this.getTypeForName("universal charstring");
    }

    @Override
    public Type getVerdict() {
        return this.getTypeForName("verdicttype");
    }

    @Override
    public void tciErrorReq(String message) {
        TciErrorReqMessage msg = new TciErrorReqMessage(message);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void writeToTCLog(String message) {
        SIWriteToTCLogMessage msg = new SIWriteToTCLogMessage(message);
        this.writeToConnection(msg, ETriTciMessageCode.Ack, true);
    }

    @Override
    public Value internalDecode(TriMessageEx msg, Type decodingHypothesis) {
        if (decodingHypothesis instanceof ExternalTciType) {
            TciDecodeMessage message = new TciDecodeMessage(msg, ((ExternalTciType)decodingHypothesis).getUniqueId());
            ValueReply ack = (ValueReply)this.writeToConnection(message, ETriTciMessageCode.ValueReply, true);
            msg.setBitPosition(ack.getDecoderBitPosition());
            return ack.createValue();
        }
        return null;
    }

    @Override
    public TriMessage internalEncode(Value value) {
        if (value instanceof ExternalTciValue) {
            TciEncodeMessage msg = new TciEncodeMessage(((ExternalTciValue)value).toValueRef());
            TriMessageReplyMessage ack = (TriMessageReplyMessage)this.writeToConnection(msg, ETriTciMessageCode.TriMessageReply, true);
            return ack.getValue();
        }
        return null;
    }

    public void enableXTriForPort(TriPortId tsiPortId, boolean enable) {
        EnableXTriMessage msgToSend = new EnableXTriMessage(tsiPortId, enable);
        this.writeToConnection(msgToSend);
    }

    private ExternalTciIntegerValue getIntegerValue(long nVal, Type type) {
        if (type == null) {
            type = TciProvider.getInstance().getTciCDRequired().getInteger();
        }
        ExternalTciIntegerValue tciVal = (ExternalTciIntegerValue)type.newInstance();
        tciVal.setInt64(nVal);
        return tciVal;
    }

    private ExternalTciFloatValue getFloatValue(double fVal, Type type) {
        if (type == null) {
            type = TciProvider.getInstance().getTciCDRequired().getFloat();
        }
        ExternalTciFloatValue tciVal = (ExternalTciFloatValue)type.newInstance();
        tciVal.setFloat(fVal);
        return tciVal;
    }

    private ExternalTciValue convertToTciValue(Object o) {
        return this.convertToTciValue(o, null);
    }

    private ExternalTciValue convertToTciValue(Object o, Type type) {
        int nType;
        int n = nType = type == null ? -1 : type.getTypeClass();
        if (o == null) {
            return null;
        }
        if (o instanceof ExternalTciValue) {
            ExternalTciValue val = (ExternalTciValue)o;
            if (type != null && val.getType().getName() != type.getName()) {
                val = null;
            }
            return val;
        }
        if (nType == -1 || nType == 10) {
            if (o instanceof Integer) {
                return this.getIntegerValue(((Integer)o).longValue(), type);
            }
            if (o instanceof Long) {
                return this.getIntegerValue((Long)o, type);
            }
            if (o instanceof Byte) {
                return this.getIntegerValue(((Byte)o).longValue(), type);
            }
            if (o instanceof Short) {
                return this.getIntegerValue(((Short)o).longValue(), type);
            }
        }
        if (nType == -1 || nType == 8) {
            if (o instanceof Double) {
                return this.getFloatValue((Double)o, type);
            }
            if (o instanceof Float) {
                return this.getFloatValue(((Float)o).doubleValue(), type);
            }
        }
        if (o instanceof String && (nType == -1 || nType == 5 || nType == 20)) {
            if (type == null) {
                type = TciProvider.getInstance().getTciCDRequired().getUniversalCharstring();
            }
            if (type.getTypeClass() == 20) {
                ExternalTciUStringValue tciVal = (ExternalTciUStringValue)type.newInstance();
                tciVal.setString((String)o);
                return tciVal;
            }
            ExternalTciCStringValue tciVal = (ExternalTciCStringValue)type.newInstance();
            tciVal.setString((String)o);
            return tciVal;
        }
        if (o instanceof Value) {
            throw new IllegalArgumentException("TCI value was not created by TestCast");
        }
        if (type == null) {
            throw new IllegalArgumentException("Uknown value format. Cannot pass the value to TE.");
        }
        return null;
    }

    private ExternalTciParameterList convertToTciValueList(TciParameterList o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ExternalTciParameterList) {
            return (ExternalTciParameterList)o;
        }
        throw new IllegalArgumentException("TCI parameter list was not created by TestCast");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterObject(long nId) {
        TriTciChannel triTciChannel = this;
        synchronized (triTciChannel) {
            if (this.m_htRegistered.remove(nId) != null) {
                this.m_unusedIds.push(nId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long registerObject(Object o) {
        long nId;
        if (o == null) {
            return 0L;
        }
        TriTciChannel triTciChannel = this;
        synchronized (triTciChannel) {
            nId = this.m_unusedIds.size() > 0 ? this.m_unusedIds.pop() : this.m_nId++;
            this.m_htRegistered.put(nId, o);
        }
        return nId;
    }

    @Override
    public void xtriEnqueueMsg(TriPortId tsiPortId, Value sutAddress, TriComponentId componentId, Object msg) {
        long nVal = this.registerObject(msg);
        long nAddr = this.registerObject(sutAddress);
        TriComponentIdImpl comp = componentId instanceof TriPortIdImpl ? (TriComponentIdImpl)componentId : new TriComponentIdImpl(componentId);
        TriPortIdImpl port = tsiPortId instanceof TriPortIdImpl ? (TriPortIdImpl)tsiPortId : new TriPortIdImpl(tsiPortId);
        XTriEnqueueMessage msgToSend = new XTriEnqueueMessage(comp, port, nVal, nAddr);
        this.writeToConnection(msgToSend, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void xtriEnqueueCall(TriPortId tsiPortId, Object sutAddress, TriComponentId componentId, TriSignatureId signatureId, TciParameterList parameterList) {
        ExternalTciParameterList tciParams = this.convertToTciValueList(parameterList);
        long nAddr = this.registerObject(sutAddress);
        TriComponentIdImpl comp = componentId instanceof TriPortIdImpl ? (TriComponentIdImpl)componentId : new TriComponentIdImpl(componentId);
        TriPortIdImpl port = tsiPortId instanceof TriPortIdImpl ? (TriPortIdImpl)tsiPortId : new TriPortIdImpl(tsiPortId);
        TriSignatureIdImpl sign = signatureId instanceof TriSignatureIdImpl ? (TriSignatureIdImpl)signatureId : new TriSignatureIdImpl(signatureId.getSignatureName());
        XTriEnqueueCallMessage msgToSend = new XTriEnqueueCallMessage(comp, port, sign, tciParams.toParameterRefList(), nAddr);
        this.writeToConnection(msgToSend, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void xtriEnqueueReply(TriPortId tsiPortId, Object sutAddress, TriComponentId componentId, TriSignatureId signatureId, TciParameterList parameterList, Value returnValue) {
        ExternalTciParameterList tciParams = this.convertToTciValueList(parameterList);
        ExternalTciValue tciRetVal = this.convertToTciValue(returnValue);
        long nAddr = this.registerObject(sutAddress);
        TriComponentIdImpl comp = componentId instanceof TriPortIdImpl ? (TriComponentIdImpl)componentId : new TriComponentIdImpl(componentId);
        TriPortIdImpl port = tsiPortId instanceof TriPortIdImpl ? (TriPortIdImpl)tsiPortId : new TriPortIdImpl(tsiPortId);
        TriSignatureIdImpl sign = signatureId instanceof TriSignatureIdImpl ? (TriSignatureIdImpl)signatureId : new TriSignatureIdImpl(signatureId.getSignatureName());
        XTriEnqueueReplyMessage msgToSend = new XTriEnqueueReplyMessage(comp, port, sign, tciParams.toParameterRefList(), tciRetVal == null ? null : tciRetVal.toValueRef(), nAddr);
        this.writeToConnection(msgToSend, ETriTciMessageCode.Ack, true);
    }

    @Override
    public void xtriEnqueueException(TriPortId tsiPortId, Object sutAddress, TriComponentId componentId, TriSignatureId signatureId, Object exc) {
        long nExc = this.registerObject(exc);
        long nAddr = this.registerObject(sutAddress);
        TriComponentIdImpl comp = componentId instanceof TriPortIdImpl ? (TriComponentIdImpl)componentId : new TriComponentIdImpl(componentId);
        TriPortIdImpl port = tsiPortId instanceof TriPortIdImpl ? (TriPortIdImpl)tsiPortId : new TriPortIdImpl(tsiPortId);
        TriSignatureIdImpl sign = signatureId instanceof TriSignatureIdImpl ? (TriSignatureIdImpl)signatureId : new TriSignatureIdImpl(signatureId.getSignatureName());
        XTriEnqueueExceptionMessage msgToSend = new XTriEnqueueExceptionMessage(comp, port, sign, nExc, nAddr);
        this.writeToConnection(msgToSend, ETriTciMessageCode.Ack, true);
    }

    public Value xtriConvert(Object value, Type typeHypothesis) {
        Value res = null;
        if (value == null) {
            res = typeHypothesis.newInstance();
        } else {
            try {
                res = this.convertToTciValue(value, typeHypothesis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res;
    }

    @Override
    public void triPAErrorReq(String message) {
        TriPAErrorReqMessage msg = new TriPAErrorReqMessage(message);
        this.writeToConnection(msg);
    }

    @Override
    public TriComponentId triSelf() {
        TriSelfMessage msg = new TriSelfMessage();
        TriSelfAckMessage ack = (TriSelfAckMessage)this.writeToConnection(msg, ETriTciMessageCode.TriSelfAck, true);
        return ack != null && ack.getStatus() == 0 ? ack.getComponent() : null;
    }

    @Override
    public TriMessage triRnd(TriComponentId componentId, TriMessage seed) {
        TriRndMessage msg = new TriRndMessage(componentId, seed);
        TriEncodedDataReply ack = (TriEncodedDataReply)this.writeToConnection(msg, ETriTciMessageCode.EncodedDataAck, true);
        return ack != null && ack.getStatus() == 0 ? ack.getEncodedData() : null;
    }

    @Override
    public void triSAErrorReq(String message) {
        TriSAErrorReqMessage msg = new TriSAErrorReqMessage(message);
        this.writeToConnection(msg);
    }

    @Override
    public void triProcessStep(TriPortIdList ports) {
        TriProcessStepMessage msg = new TriProcessStepMessage(ports);
        this.writeToConnection(msg);
    }

    @Override
    public void triEndWait(TriComponentId compId) {
        TriEndWaitMessage msg = new TriEndWaitMessage(compId);
        this.writeToConnection(msg);
    }

    Object getRegisteredObject(long id) {
        return this.m_htRegistered.get(id);
    }

    @Override
    public void xtriPAErrorReq(String message, Object cause) {
        this.triPAErrorReq(message);
    }

    @Override
    public void xtriSAErrorReq(String message, Object cause) {
        this.triSAErrorReq(message);
    }

    ExternalRangeBoundary getLowerTypeBoundary(long m_nId) {
        TciGetLowerTypeBoundaryMessage msg = new TciGetLowerTypeBoundaryMessage(m_nId);
        RangeBoundaryReply reply = (RangeBoundaryReply)this.writeToConnection(msg, ETriTciMessageCode.RangeBoundaryReply, false);
        if (reply != null) {
            return reply.createBoundary();
        }
        return null;
    }

    ExternalRangeBoundary getUpperTypeBoundary(long m_nId) {
        TciGetUpperTypeBoundaryMessage msg = new TciGetUpperTypeBoundaryMessage(m_nId);
        RangeBoundaryReply reply = (RangeBoundaryReply)this.writeToConnection(msg, ETriTciMessageCode.RangeBoundaryReply, false);
        if (reply != null) {
            return reply.createBoundary();
        }
        return null;
    }

    TciLengthRestriction getTypeLengthRestriction(long m_nId) {
        TciGetTypeLengthRestrictionMessage msg = new TciGetTypeLengthRestrictionMessage(m_nId);
        LengthRestrictionReply reply = (LengthRestrictionReply)this.writeToConnection(msg, ETriTciMessageCode.LenRestrictionReply, false);
        if (reply != null) {
            return reply.getLengthRestriction();
        }
        return null;
    }

    String convertTciValueToXml(long nId) {
        ConvertTciValueToXmlMessage msg = new ConvertTciValueToXmlMessage(nId);
        SimpleStringReply reply = (SimpleStringReply)this.writeToConnection(msg, ETriTciMessageCode.SimpleStringReply, false);
        if (reply != null) {
            return reply.getValue();
        }
        return null;
    }

    int isMatching(long nId) {
        IsMatchingSymbolMessage msg = new IsMatchingSymbolMessage(nId);
        ByteReply reply = (ByteReply)this.writeToConnection(msg, ETriTciMessageCode.ByteReply, false);
        int nRes = -1;
        if (reply != null && reply.getValue() > 0) {
            nRes = reply.getValue() - 1;
        }
        return nRes;
    }

    private class ReceivingThread
    extends Thread {
        private TriTciChannel m_channel;

        public ReceivingThread(TriTciChannel channel) {
            this.m_channel = channel;
        }

        @Override
        public void run() {
            this.m_channel.receiveProc();
        }
    }
}

