/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.etsi.ttcn.tci.LengthRestriction;

public class TciLengthRestriction
extends AbstractTriTciClass
implements LengthRestriction {
    private int m_nLower = 0;
    private int m_nUpper = Integer.MAX_VALUE;
    private boolean m_bInfinity;

    public TciLengthRestriction() {
    }

    public TciLengthRestriction(LengthRestriction src) {
        this.m_nLower = src.getLowerBoundary();
        if (src.isUpperBoundaryInfinity()) {
            this.m_bInfinity = true;
        } else {
            this.m_nUpper = src.getUpperBoundary();
        }
    }

    @Override
    public int getLowerBoundary() {
        return this.m_nLower;
    }

    @Override
    public void setLowerBoundary(int boundary) throws IllegalArgumentException {
        if (boundary > this.m_nUpper && !this.m_bInfinity) {
            throw new IllegalArgumentException("Cannot be greater than upper range");
        }
        if (boundary < 0) {
            throw new IllegalArgumentException("Negative values not allowed");
        }
        this.m_nLower = boundary;
    }

    @Override
    public int getUpperBoundary() throws UnsupportedOperationException {
        if (this.m_bInfinity) {
            throw new UnsupportedOperationException("Infinite upper range");
        }
        return this.m_nUpper;
    }

    @Override
    public void setUpperBoundary(int boundary) {
        if (boundary < this.m_nLower) {
            throw new IllegalArgumentException("Cannot be less than lower range");
        }
        this.m_nUpper = boundary;
        this.m_bInfinity = false;
    }

    @Override
    public boolean isUpperBoundaryInfinity() {
        return this.m_bInfinity;
    }

    @Override
    public void setInfiniteUpperBoundary() {
        this.m_bInfinity = true;
        this.m_nUpper = Integer.MAX_VALUE;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        TciLengthRestriction.writeLong(ms, this.m_nLower);
        TciLengthRestriction.writeBool(ms, this.m_bInfinity);
        if (!this.m_bInfinity) {
            TciLengthRestriction.writeLong(ms, this.m_nUpper);
        }
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        this.m_nLower = (int)TciLengthRestriction.readLong(ms);
        this.m_bInfinity = TciLengthRestriction.readBool(ms);
        this.m_nUpper = !this.m_bInfinity ? (int)TciLengthRestriction.readLong(ms) : Integer.MAX_VALUE;
    }

    public TciLengthRestriction clone() {
        TciLengthRestriction res = new TciLengthRestriction();
        res.m_nLower = this.m_nLower;
        res.m_nUpper = this.m_nUpper;
        res.m_bInfinity = this.m_bInfinity;
        return res;
    }
}

