/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciModuleParameterIdImpl;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.ValueReply;
import org.etsi.ttcn.tci.TciModuleParameterId;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriStatus;

class TciGetModuleParMessage
extends AbstractTriTciMessage {
    private TciModuleParameterIdImpl m_modParId;

    public TciGetModuleParMessage(TciModuleParameterId modParId) {
        if (modParId instanceof TciModuleParameterIdImpl) {
            this.m_modParId = (TciModuleParameterIdImpl)modParId;
        } else if (modParId != null) {
            this.m_modParId = new TciModuleParameterIdImpl(modParId);
        }
    }

    public TciGetModuleParMessage() {
    }

    public TciModuleParameterIdImpl getModuleParId() {
        return this.m_modParId;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciGetModuleParMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.GetModulePar;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_modParId.serialize(ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_modParId = new TciModuleParameterIdImpl();
        this.m_modParId.deserialize(ms);
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TciProvider.getInstance().getTciTMProvided() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ValueReply ack;
        Value val = null;
        TriStatus status = TriStatusImpl.ok();
        try {
            val = TciProvider.getInstance().getTciTMProvided().tciGetModulePar(this.m_modParId);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        if (val instanceof ExternalTciValue) {
            ExternalTciValue extVal = (ExternalTciValue)val;
            ack = new ValueReply(extVal.toValueRef(), 0);
        } else {
            ack = val == null ? new ValueReply(null, status.getStatus()) : new ValueReply(null, -1);
        }
        return new AdapterProcessingResult(status, ack);
    }
}

