/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriStatusImpl;

abstract class AbstractTriTciMessage
extends AbstractTriTciClass {
    public static final int NO_THREAD = -1;
    private int m_nServerChannelId = -1;
    private int m_nClientChannelId = -1;

    protected AbstractTriTciMessage() {
    }

    public abstract ETriTciMessageCode getMessageCode();

    public String getMessageName() {
        String s = this.getClass().getName();
        int nIndex = s.lastIndexOf(46);
        if (nIndex > -1) {
            s = s.substring(nIndex + 1);
        }
        if (s.endsWith("Message")) {
            s = s.substring(0, s.length() - 7);
        }
        return s;
    }

    public int getServerChannelId() {
        return this.m_nServerChannelId;
    }

    public void setServerChannelId(int nId) {
        this.m_nServerChannelId = nId;
    }

    public int getClientChannelId() {
        return this.m_nClientChannelId;
    }

    public void setClientChannelId(int nId) {
        this.m_nClientChannelId = nId;
    }

    protected boolean isSessionIdRequired() {
        return true;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        if (this.isSessionIdRequired()) {
            this.m_nServerChannelId = AbstractTriTciMessage.readInt(ms);
            this.m_nClientChannelId = AbstractTriTciMessage.readInt(ms);
        }
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        if (this.isSessionIdRequired()) {
            AbstractTriTciMessage.writeInt(ms, this.m_nServerChannelId);
            AbstractTriTciMessage.writeInt(ms, this.m_nClientChannelId);
        }
    }

    public abstract AbstractTriTciMessage createEmptyInstance();

    @Override
    public boolean deserialize(ByteArrayInputStream ms) {
        boolean bRes = false;
        try {
            this.deserializeProc(ms);
            bRes = ms.available() == 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRes;
    }

    protected void serializeOptionalTciValue(TciValueRef val, ByteArrayOutputStream ms) {
        if (val == null) {
            ms.write(0);
        } else {
            ms.write(255);
            val.serialize(ms);
        }
    }

    protected TciValueRef deserializeOptionalTciValue(ByteArrayInputStream ms) {
        if (ms.read() == 0) {
            return null;
        }
        TciValueRef res = new TciValueRef();
        res.deserialize(ms);
        return res;
    }

    public boolean isSupportedInAdapter() {
        return false;
    }

    public AdapterProcessingResult processInAdapter() {
        return new AdapterProcessingResult(TriStatusImpl.error());
    }
}

