package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class TestDiff_005_fixed_fraction {
	public static final String FOLDER = "xml/005_real";
	public static String XSD_FILE = "005_real_item.xsd";
	public static String FILE_no_fraction = "01_fixed_no_fraction.xml";
	public static String FILE_no_fraction_0 = "01_fixed_no_fraction_0.xml";
	public static String FILE_no_fraction_00 = "01_fixed_no_fraction_00.xml";
	public static String FILE_no_fraction__plus = "01_fixed_no_fraction__plus.xml";
	public static String FILE_no_fraction_0_plus = "01_fixed_no_fraction_0_plus.xml";
	public static String FILE_no_fraction_00_plus = "01_fixed_no_fraction_00_plus.xml";
	public static final String FILE_base = FILE_no_fraction;
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File(FOLDER);
		differ = new XmlDiff(
				new File(root, FILE_base), 
				new String[]{XSD_FILE},
				new String[]{FOLDER});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_self() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_base));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_0() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_no_fraction_0));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test_00() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_no_fraction_00));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test__plus() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_no_fraction__plus));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test_0_plus() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_no_fraction_0_plus));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test_00_plus() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_no_fraction_00_plus));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}
}
