/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriCommOperation;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.ValueReply;
import org.elvior.ttcn.tritci.XTriStatusRead;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.xtri.xTriCommunicationSA;

class XTriReadStatusMessage
extends AbstractTriCommOperation {
    private long m_nTypeId;
    private TciValueRef m_portStatus;

    public XTriReadStatusMessage() {
    }

    public XTriReadStatusMessage(TriComponentIdImpl comp, TriPortIdImpl systemPort, TciValueRef portStatus, long nTypeId) {
        super(comp, systemPort);
        this.m_portStatus = portStatus;
        this.m_nTypeId = nTypeId;
    }

    ExternalTciType createType() {
        return new ExternalTciType(this.m_nTypeId);
    }

    public TciValueRef getPortStatus() {
        return this.m_portStatus;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.serializeOptionalTciValue(this.m_portStatus, ms);
        XTriReadStatusMessage.writeLong(ms, this.m_nTypeId);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_portStatus = this.deserializeOptionalTciValue(ms);
        this.m_nTypeId = XTriReadStatusMessage.readLong(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.XReadStatus;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new XTriReadStatusMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() instanceof xTriCommunicationSA && TriProvider.getInstance().getTriCommunicationSA() instanceof XTriStatusRead;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TciValueRef res = null;
        ExternalTciValue paramVal = null;
        TriStatus status = TriStatusImpl.ok();
        if (this.m_portStatus != null) {
            paramVal = this.m_portStatus.createValue();
        }
        ExternalTciType typeHypothesis = this.createType();
        try {
            Value val = ((XTriStatusRead)((Object)TriProvider.getInstance().getTriCommunicationSA())).xtriRead(this.getComponentId(), this.getSystemPortId(), paramVal, typeHypothesis);
            if (val instanceof ExternalTciValue) {
                ExternalTciValue tciVal = (ExternalTciValue)val;
                res = tciVal.toValueRef();
            } else {
                status = TriStatusImpl.error();
            }
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        ValueReply ack = new ValueReply(res, status.getStatus());
        return new AdapterProcessingResult(status, ack);
    }
}

