/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciParameterRef;
import org.elvior.ttcn.tritci.TciValueRef;
import org.etsi.ttcn.tci.TciParameter;
import org.etsi.ttcn.tci.Value;

class ExternalTciParameter
implements TciParameter {
    private String m_sParameterName;
    private int m_nPassMode;
    private ExternalTciValue m_value;

    public ExternalTciParameter() {
    }

    public ExternalTciParameter(TciParameterRef src) {
        this.m_sParameterName = src.getName();
        this.m_nPassMode = src.getPassingMode();
        if (src.getValueReference() != null) {
            this.m_value = src.getValueReference().createValue();
        }
    }

    public ExternalTciParameter(TciParameter src) {
        this.m_sParameterName = src.getParameterName();
        this.m_nPassMode = src.getParameterPassingMode();
        this.setParameter(src.getParameter());
    }

    @Override
    public String getParameterName() {
        return this.m_sParameterName;
    }

    @Override
    public void setParameterName(String sName) {
        this.m_sParameterName = sName;
    }

    @Override
    public int getParameterPassingMode() {
        return this.m_nPassMode;
    }

    @Override
    public void setParameterPassingMode(int nMode) {
        if (nMode != 0 && nMode != 1 && nMode != 2) {
            throw new IllegalArgumentException("Invalid passing mode");
        }
        this.m_nPassMode = nMode;
    }

    @Override
    public Value getParameter() {
        return this.m_value;
    }

    @Override
    public void setParameter(Value value) {
        if (value != null && !(value instanceof ExternalTciValue)) {
            throw new IllegalArgumentException("TCI value not created by MM");
        }
        this.m_value = (ExternalTciValue)value;
    }

    public TciParameterRef toParameterRef() {
        TciValueRef valRef = null;
        if (this.m_value != null) {
            valRef = this.m_value.toValueRef();
        }
        return new TciParameterRef(this.m_sParameterName, this.m_nPassMode, valRef);
    }
}

