/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTliMessage;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciStatusImpl;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriMessageImpl;
import org.etsi.ttcn.tci.TciStatus;

public abstract class TliAbstractCodecMessage
extends AbstractTliMessage {
    private TciValueRef m_val;
    private TciStatus m_codecFailure;
    private TriMessageImpl m_msg;
    private String m_codec;

    public TliAbstractCodecMessage(String am, long ts, String src, int line, TriComponentIdImpl c, TciValueRef val, TciStatus codecFailure, TriMessageImpl msg, String codec) {
        super(am, ts, src, line, c);
        this.m_val = val;
        this.m_codecFailure = codecFailure;
        this.m_msg = msg;
        this.m_codec = codec;
    }

    public TliAbstractCodecMessage() {
    }

    public ExternalTciValue getValue() {
        return this.createOptValue(this.m_val);
    }

    public TciStatus getCodecFailure() {
        return this.m_codecFailure;
    }

    public TriMessageImpl getMessage() {
        return this.m_msg;
    }

    public String getCodec() {
        return this.m_codec;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.writeOptionalObject(this.m_val, ms);
        TliAbstractCodecMessage.writeBool(ms, this.m_codecFailure.getTciStatus() == -1);
        this.writeOptionalObject(this.m_msg, ms);
        TliAbstractCodecMessage.writeUString(ms, this.m_codec);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_val = this.readOptionalObject(ms, TciValueRef.class);
        this.m_codecFailure = TliAbstractCodecMessage.readBool(ms) ? TciStatusImpl.error() : TciStatusImpl.ok();
        this.m_msg = this.readOptionalObject(ms, TriMessageImpl.class);
        this.m_codec = TliAbstractCodecMessage.readUString(ms);
    }
}

