/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriTciChannel;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;

class ExternalTciValue
implements Value {
    private long m_nId;
    private ExternalTciType m_type;
    protected static final String UNKNOWN = "_unknown_";
    private String m_sEnc = "_unknown_";
    private String m_sVariant = "_unknown_";

    public ExternalTciValue(long nId) {
        this.m_nId = nId;
    }

    public void finalize() {
        TriTciChannel.getInstance().unregisterTciObject(this.m_nId);
    }

    long getId() {
        return this.m_nId;
    }

    @Override
    public synchronized Type getType() {
        if (this.m_type == null) {
            this.m_type = TriTciChannel.getInstance().getValueType(this.m_nId);
        }
        return this.m_type;
    }

    void setType(ExternalTciType type) {
        this.m_type = type;
    }

    @Override
    public boolean notPresent() {
        return TriTciChannel.getInstance().getNotPresent(this.m_nId);
    }

    @Override
    public synchronized String getValueEncoding() {
        if (this.m_sEnc == UNKNOWN) {
            this.m_sEnc = TriTciChannel.getInstance().getValueEncoding(this.m_nId);
        }
        return this.m_sEnc;
    }

    @Override
    public synchronized String getValueEncodingVariant() {
        if (this.m_sVariant == UNKNOWN) {
            this.m_sVariant = TriTciChannel.getInstance().getValueVariant(this.m_nId);
        }
        return this.m_sVariant;
    }

    protected boolean compareId(ExternalTciValue obj) {
        return this.m_nId == obj.m_nId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExternalTciValue) {
            return this.compareId((ExternalTciValue)obj);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.m_nId;
    }

    protected long getTciValueId(Value val) {
        if (val instanceof ExternalTciValue) {
            return ((ExternalTciValue)val).getId();
        }
        throw new RuntimeException("Invalid TCI value format");
    }

    public TciValueRef toValueRef() {
        return new TciValueRef(this.m_nId, this.getType().getTypeClass());
    }
}

