import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;


public class TestCastProjectBuilder {
	private String files = "";
	private String sut = "";
	private boolean m_bElemSubst, m_bTypeSubst;
	
	private String template1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + 
	"<solution>\n" + 
	" <scripts>\n" + 
	"  <items>\n"; 
	
	private String template2 = 
		"  </items>\n" + 
		" </scripts>\n" + 
		" <verstool />\n"; 

	private String template3 = 
	" <ExternalAttributeFiles>\n" + 
	"  <items />\n" + 
	" </ExternalAttributeFiles>\n" + 
	" <ModuleParFiles>\n" + 
	"  <items />\n" + 
	" </ModuleParFiles>\n" + 
	" <TestcaseSelections>\n" + 
	"  <items />\n" + 
	" </TestcaseSelections>\n" + 
	" <TestCampaigns>\n" + 
	"  <items />\n" + 
	" </TestCampaigns>\n" + 
	" <ttcn3_settings>\n" + 
	"  <tc_block />\n" + 
	"  <ttcn3_version>Ttcn3_2016</ttcn3_version>\n" + 
	"  <asn>BER</asn>\n" + 
	"  <dll_timeout>10</dll_timeout>\n" + 
	"  <port>7777</port>\n" + 
	"  <ctime>60</ctime>\n" + 
	"  <sa_count>1</sa_count>\n" + 
	"  <rtime>20</rtime>\n" + 
	"  <codec_type>internal</codec_type>\n" + 
	"  <enc>\n" + 
	"   <text>\n" + 
	"    <ifrmt>dec</ifrmt>\n" + 
	"    <char>UTF8</char>\n" + 
	"    <byte_order>le</byte_order>\n" + 
	"    <psep>:</psep>\n" + 
	"    <ws> \\t</ws>\n" + 
	"    <sep>;</sep>\n" + 
	"   </text>\n" + 
	"  </enc>\n";
	
	private String template4 = 
	"  <no_bs_dq />\n" + 
	"  <length-form>definite</length-form>\n" + 
	"  <forbidden_ctrl_warn />\n" +
	"  <omit-match-err />\n" +
	"  <log-tmpt-names />\n" +
	"  <strict-def-check />\n" +
	"  <default-step>0.1</default-step>\n" +
	"  <strict-ver-check />\n" +
	"  <dll_ctimeout>10</dll_ctimeout>\n" +
	" </ttcn3_settings>\n" + 
	"</solution>";
	
	public void addFile(String filename) {
		File f = new File(filename);
		files += "   <script>\n";
		if (filename.endsWith(".xsd"))
			files += "    <name>" + f.getName().substring(0, f.getName().indexOf(".xsd")) + "_xsd</name>\n";
		else
			files += "    <name>" + f.getName().substring(0, f.getName().indexOf(".ttcn")) + "</name>\n";
		files += "    <file>" + filename + "</file>\n"; 
		if (filename.endsWith(".xsd"))
			files += "    <type>xsd</type>\n"; 
		else
			files += "    <type>ttcn3</type>\n"; 
		files += "   </script>\n"; 
	}

	public void setSUT(String sutFile) {
		sut = " <sut>\n";
		sut += "  <exe>\"" + sutFile + "\"</exe>\n";
		sut += " </sut>\n";
	}
	
	public String getProjectFileString() {
		StringBuilder sb = new StringBuilder();
		sb.append(template1);
		sb.append(files);
		sb.append(template2);
		sb.append(sut);
		sb.append(template3);
		if (m_bElemSubst)
			sb.append("  <elem_subst />");
		if (m_bTypeSubst)
			sb.append("  <type_subst />");
		sb.append(template4);
		return sb.toString();
	}
	
	public void saveProjectFile(File f) {
		 PrintWriter out;
		try {
			out = new PrintWriter(new FileWriter(f));
			 out.print(getProjectFileString());
			 out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void setElementSubstitutions(boolean bEnabled) {
		m_bElemSubst = bEnabled;
	}

	public void setTypeSubstitutions(boolean bEnabled) {
		m_bTypeSubst = bEnabled;
	}
}
