// ICS is not generated anymore. we keep this only as a reference for possible further tools.

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ICSProformaTableGenerator {

	public static Properties config = new Properties();
	public static Properties references = new Properties();
	private ArrayList<File> files = new ArrayList<File>();
	private HashMap<String, ArrayList<ClauseEntry>> clauseMap = new HashMap<String, ArrayList<ClauseEntry>>();
	
	// -----------------------------------------------------------------------------------------------

	public ICSProformaTableGenerator() {
	}

	// -----------------------------------------------------------------------------------------------

	public void run() {
		System.out.println("STF475 Tools: ICS Proforma Table Generator v0.1");
		try {
			FileUtils.loadConfig(config);
			FileUtils.loadReferences(references);
		} catch (IOException e) {
			System.err
					.println("[ERROR] Cannot load config file or config file is incomplete.");
			return;
		}

		List<Clause> myList = new ArrayList<Clause>();
		Iterator<Object> it = references.keySet().iterator();
		System.out.println("----");
		while (it.hasNext()) {
			Object value = it.next();
			if (value instanceof String) {
				myList.add(new Clause((String) value));
			}
		}
		
		Collections.sort(myList);

		String atsPath = config.get("ATSPath").toString();
		System.out.println("Gathering files...");
		FileUtils.visitAllFiles(new File(atsPath), files);

		System.out.println("Processing files...");
		for (int i=0; i < files.size(); i++) {
			File origFile = files.get(i);
//			File tempFile = new File(config.get("TempPath") + "/" + origFile.getName());
			File tempFile = origFile;  // use original file instead of a copy
			T3Purpose purpose = FileUtils.extractPurpose(tempFile);
			T3ExpectedOutput expected = FileUtils.extractExpectedOutput(tempFile);
//			System.out.println(purpose.getClauseStructured());
			ArrayList<ClauseEntry> clauseEntries = clauseMap.get(purpose.getClauseStructured().toString());
			if (clauseEntries == null)
				clauseEntries = new ArrayList<ClauseEntry>();
			
			ClauseEntry clauseEntry = new ClauseEntry();
			clauseEntry.setFile(tempFile);
			clauseEntry.setPurpose(purpose);
			clauseEntry.setExpected(expected);
			clauseEntries.add(clauseEntry);
			clauseMap.put(purpose.getClauseStructured().toString(), clauseEntries);
			
//			System.out.println(purpose);
//			System.out.println("  " +references.get(purpose.getClause()));
		}

		
		try {
			String icsFileHead = FileUtils.loadFileToString(new File("resources/ics-file-head.html"));
			String icsFileFooter = FileUtils.loadFileToString(new File("resources/ics-file-foot.html"));
			String icsSectionHead = FileUtils.loadFileToString(new File("resources/ics-section-head.html"));
			String icsSectionFoot = FileUtils.loadFileToString(new File("resources/ics-section-foot.html"));
			String icsTableRow = FileUtils.loadFileToString(new File("resources/ics-table-line.html"));
			
			StringBuffer result = new StringBuffer();
			
			result.append(icsFileHead);
			
			int tableCounter = 0;
			int sectionCounter = 1;
			for (int i=0; i < myList.size(); i++) {
				Clause clause = myList.get(i);
				ArrayList<ClauseEntry> clauseEntries = clauseMap.get(clause.toString());
				
				if (clauseEntries != null && clauseEntries.size() > 0) {
					tableCounter++;
					sectionCounter++;
					result.append(createSectionHead(icsSectionHead, "A.3." + sectionCounter, references.getProperty(clause.toString()), "A." + tableCounter));
					for (int j=0; j < clauseEntries.size(); j++) {
						String purposeText = clauseEntries.get(j).getPurpose().getPurposeText();
						if (purposeText.startsWith("Ensure that")) {
							purposeText = purposeText.replaceAll("^Ensure that", "").trim();
							String temp = purposeText.substring(0, 1).toUpperCase() + purposeText.substring(1);
							purposeText = temp;
						}
						
						result.append(createTableRow(icsTableRow, j+1, purposeText, "Clause " + clause, "m", clauseEntries.get(j).getFile().getName().replaceAll("\\.ttcn", "")));
					}
					result.append(icsSectionFoot);
				}
				
			}
			
			result.append(icsFileFooter);
			
			//System.out.println(result.toString());
			FileUtils.saveStringToFile(new File(config.get("DeliverableATSPath")+"/stf475-ics.html"), result.toString());
			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		
		
//		for (int i=0; i < myList.size(); i++) {
//			String clauseDesc = references.getProperty(myList.get(i).toString());
//			System.out.println(myList.get(i) + " - " + clauseDesc);
//		}
//		System.out.println("----");
		
		
		System.out.println("done.");
	}

	// -----------------------------------------------------------------------------------------------

	private String createTableRow(String tableRow, int number, String purpose, String clause, String status, String tpRef) throws IOException {
		String icsTableRow = tableRow.replaceAll("\\{\\{NUMBER\\}\\}", Integer.toString(number));
		icsTableRow = icsTableRow.replaceAll("\\{\\{PURPOSE\\}\\}", purpose);
		icsTableRow = icsTableRow.replaceAll("\\{\\{CLAUSE\\}\\}", clause);
		icsTableRow = icsTableRow.replaceAll("\\{\\{STATUS\\}\\}", status);
		icsTableRow = icsTableRow.replaceAll("\\{\\{TCTPREF\\}\\}", tpRef);
		
		return icsTableRow;
		
	}
	
	private String createSectionHead(String sectionHead, String targetClause, String clauseDescription, String tableNumber) {
		String icsSectionHead = sectionHead.replaceAll("\\{\\{TARGETCLAUSE\\}\\}", targetClause);
		icsSectionHead = icsSectionHead.replaceAll("\\{\\{CLAUSEDESCRIPTION\\}\\}", clauseDescription);
		icsSectionHead = icsSectionHead.replaceAll("\\{\\{TABLENUMBER\\}\\}", tableNumber);
		return icsSectionHead;
	}
	
	// -----------------------------------------------------------------------------------------------

	public static void main(String[] args) {
		new ICSProformaTableGenerator().run();
	}

}
