package org.etsi.mts.ttcn.part9.xmldiff;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.junit.Before;
import org.junit.Test;

public class TestDiff_002 {
	public static String FILE_base = "Pos_070401_AttributeElementDefinition_001_01_base.xml";
	public static String FILE_whitespace = "Pos_070401_AttributeElementDefinition_001_02_whitespace.xml";
	public static String FILE_comment = "Pos_070401_AttributeElementDefinition_001_03_comment.xml";
	public static String FILE_nmsp_prefix = "Pos_070401_AttributeElementDefinition_001_04_nmsp_prefix.xml";
	public static String FILE_attr_order = "Pos_070401_AttributeElementDefinition_001_05_attr_order.xml";
	public static String FILE_no_nmsp_prefix = "Pos_070401_AttributeElementDefinition_001_06_no_nmsp_prefix.xml";
	public static String FILE_escape = "Pos_070401_AttributeElementDefinition_001_07_escape.xml";
	public static String FILE_xsd = "Pos_070401_AttributeElementDefinition_001.xsd";
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File("xml/002");
		differ = new XmlDiff(new File(root, FILE_base), new String[]{FILE_xsd}, new String[]{"xml/002"});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_whitespace() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_whitespace));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test_comment() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_comment));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_nmsp_prefix() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_nmsp_prefix));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test_attr_order() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_attr_order));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_no_nmsp_prefix() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_no_nmsp_prefix));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_escape() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_escape));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
}
