/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriComponentMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriStatus;

class TriBeginWaitMessage
extends AbstractTriComponentMessage {
    private long m_nTick;

    public TriBeginWaitMessage() {
    }

    public TriBeginWaitMessage(TriComponentIdImpl comp, long nTick) {
        super(comp);
        this.m_nTick = nTick;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriBeginWaitMessage();
    }

    public long getTick() {
        return this.m_nTick;
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriPlatformPA().triBeginWait(this.m_nTick, this.getComponentId());
        return new AdapterProcessingResult(status);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TriBeginWaitMessage.writeLong(ms, this.m_nTick);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_nTick = TriBeginWaitMessage.readLong(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.BeginWait;
    }
}

