/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractEncodeMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciEncodeReply;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tri.TriMessage;

public class TciEncodeValueMessage
extends AbstractEncodeMessage {
    private String m_sEncodingInfo;

    public TciEncodeValueMessage(TciValueRef valRef, String sEncodingInfo) {
        super(valRef);
        this.m_sEncodingInfo = sEncodingInfo;
    }

    public TciEncodeValueMessage() {
    }

    public String getEncodingInfo() {
        return this.m_sEncodingInfo;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ExternalTciValue extVal = this.getValueReference().createValue();
        TriMessage encoded = null;
        try {
            encoded = TciProvider.getInstance().getTciCDProvided().encodeValue(extVal, this.m_sEncodingInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TciEncodeReply ack = new TciEncodeReply(encoded, encoded == null ? -1 : 0);
        return new AdapterProcessingResult(TriStatusImpl.ok(), ack);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TciEncodeValueMessage.writeUString(ms, this.m_sEncodingInfo);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_sEncodingInfo = TciEncodeValueMessage.readUString(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.EncodeValue;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciEncodeValueMessage();
    }
}

