/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractDecodeMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.DecodeReply;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tci.TciDecodingResult;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriMessage;
import org.etsi.ttcn.tri.TriStatus;

public class TciDecodeValueMessage
extends AbstractDecodeMessage {
    private String m_sEncodingInfo;

    public TciDecodeValueMessage(TriMessage message, long nTypeId, String sEncodingInfo) {
        super(message, nTypeId);
        this.m_sEncodingInfo = sEncodingInfo;
    }

    public TciDecodeValueMessage() {
    }

    public String getEncodingInfo() {
        return this.m_sEncodingInfo;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        DecodeReply ack;
        ExternalTciType type = new ExternalTciType(this.getId());
        Value val = null;
        TriStatus status = TriStatusImpl.ok();
        int nRes = 1;
        try {
            TciDecodingResult res = TciProvider.getInstance().getTciCDProvided().decodeValue(this.getMessage(), type, this.m_sEncodingInfo);
            val = res.getDecodedValue();
            nRes = res.getResult();
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        if (val instanceof ExternalTciValue) {
            ExternalTciValue extVal = (ExternalTciValue)val;
            ack = new DecodeReply(nRes, extVal.toValueRef(), this.getMessage().getBitPosition(), 0);
        } else {
            ack = val == null ? new DecodeReply(nRes, null, this.getMessage().getBitPosition(), status.getStatus()) : new DecodeReply(nRes, null, this.getMessage().getBitPosition(), -1);
        }
        return new AdapterProcessingResult(status, ack);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciDecodeValueMessage();
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TciDecodeValueMessage.writeUString(ms, this.m_sEncodingInfo);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_sEncodingInfo = TciDecodeValueMessage.readUString(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.DecodeValue;
    }
}

