/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.TciLengthRestriction;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriTciChannel;
import org.etsi.ttcn.tci.LengthRestriction;
import org.etsi.ttcn.tci.MatchingMechanism;
import org.etsi.ttcn.tci.RangeBoundary;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;

class ExternalTciValue
implements Value {
    private ExternalTciType m_type;
    protected static final String UNKNOWN = "_unknown_";
    private String m_sEnc = "_unknown_";
    private String m_sVariant = "_unknown_";
    private TciValueRef m_ref;

    public ExternalTciValue(TciValueRef parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.m_ref = parent;
    }

    protected long getId() {
        return this.m_ref.getId();
    }

    @Override
    public synchronized Type getType() {
        if (this.m_type == null) {
            this.m_type = TriTciChannel.getInstance().getValueType(this.getId());
        }
        return this.m_type;
    }

    void setType(ExternalTciType type) {
        this.m_type = type;
    }

    @Override
    public boolean notPresent() {
        return TriTciChannel.getInstance().getNotPresent(this.getId());
    }

    @Override
    public synchronized String getValueEncoding() {
        if (this.m_sEnc == UNKNOWN) {
            this.m_sEnc = TriTciChannel.getInstance().getValueEncoding(this.getId());
        }
        return this.m_sEnc;
    }

    @Override
    public synchronized String getValueEncodingVariant() {
        if (this.m_sVariant == UNKNOWN) {
            this.m_sVariant = TriTciChannel.getInstance().getValueVariant(this.getId());
        }
        return this.m_sVariant;
    }

    protected boolean compareId(ExternalTciValue obj) {
        return this.getId() == obj.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExternalTciValue) {
            return this.compareId((ExternalTciValue)obj);
        }
        return false;
    }

    @Override
    public boolean isMatchingSymbol() {
        return false;
    }

    @Override
    public String valueToString() {
        return TriTciChannel.getInstance().valueToString(this.getId());
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isFuzzy() {
        return false;
    }

    @Override
    public boolean isEvaluated() {
        return true;
    }

    @Override
    public LengthRestriction getLengthRestriction() {
        return TriTciChannel.getInstance().getLengthRestriction(this.getId());
    }

    @Override
    public LengthRestriction newLengthRestriction() {
        return new TciLengthRestriction();
    }

    @Override
    public void setLengthRestriction(LengthRestriction restriction) {
        TriTciChannel.getInstance().setLengthRestriction(this.getId(), restriction);
    }

    @Override
    public boolean isIfPresentEnabled() {
        return TriTciChannel.getInstance().isIfPresentEnabled(this.getId());
    }

    @Override
    public void setIfPresentEnabled(boolean enabled) {
        TriTciChannel.getInstance().setIfPresentEnabled(this.getId(), enabled);
    }

    @Override
    public RangeBoundary getLowerTypeBoundary() {
        return this.m_type.getLowerTypeBoundary();
    }

    @Override
    public RangeBoundary getUpperTypeBoundary() {
        return this.m_type.getUpperTypeBoundary();
    }

    @Override
    public LengthRestriction getTypeLengthRestriction() {
        return this.m_type.getTypeLengthRestriction();
    }

    @Override
    public MatchingMechanism getTypeMatchingMechanism() {
        return null;
    }

    public int hashCode() {
        return (int)this.getId();
    }

    protected long getTciValueId(Value val) {
        if (val instanceof ExternalTciValue) {
            return ((ExternalTciValue)val).getId();
        }
        throw new RuntimeException("Invalid TCI value format");
    }

    TciValueRef toValueRef() {
        return this.m_ref;
    }
}

