/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.elvior.ttcn.tritci.BitConverter;

abstract class AbstractTriTciClass {
    protected AbstractTriTciClass() {
    }

    private static void checkEnoughBytes(ByteArrayInputStream ms, int nRequired) throws IOException {
        if (ms.available() < nRequired) {
            throw new IOException("Not enough bytes");
        }
    }

    protected static void writeBool(ByteArrayOutputStream ms, boolean bVal) {
        ms.write(bVal ? 255 : 0);
    }

    protected static boolean readBool(ByteArrayInputStream ms) throws IOException {
        AbstractTriTciClass.checkEnoughBytes(ms, 1);
        return ms.read() != 0;
    }

    protected static void writeShort(ByteArrayOutputStream ms, short nVal) {
        byte[] aVal = BitConverter.getBytes(nVal);
        ms.write(aVal, 0, aVal.length);
    }

    protected static short readShort(ByteArrayInputStream ms) throws IOException {
        AbstractTriTciClass.checkEnoughBytes(ms, 2);
        byte[] aVal = new byte[2];
        ms.read(aVal, 0, 2);
        return BitConverter.toShort(aVal);
    }

    protected static void writeInt(ByteArrayOutputStream ms, int nVal) {
        byte[] aVal = BitConverter.getBytes(nVal);
        ms.write(aVal, 0, aVal.length);
    }

    protected static int readInt(ByteArrayInputStream ms) throws IOException {
        AbstractTriTciClass.checkEnoughBytes(ms, 4);
        byte[] aVal = new byte[4];
        ms.read(aVal, 0, 4);
        return BitConverter.toInt(aVal);
    }

    protected static void writeLong(ByteArrayOutputStream ms, long nVal) {
        byte[] aVal = BitConverter.getBytes(nVal);
        ms.write(aVal, 0, aVal.length);
    }

    protected static long readLong(ByteArrayInputStream ms) throws IOException {
        AbstractTriTciClass.checkEnoughBytes(ms, 8);
        byte[] aVal = new byte[8];
        ms.read(aVal, 0, 8);
        return BitConverter.toLong(aVal);
    }

    protected static void writeDouble(ByteArrayOutputStream ms, double fVal) {
        byte[] aVal = BitConverter.getBytes(fVal);
        ms.write(aVal, 0, aVal.length);
    }

    protected static double readDouble(ByteArrayInputStream ms) throws IOException {
        AbstractTriTciClass.checkEnoughBytes(ms, 8);
        byte[] aVal = new byte[8];
        ms.read(aVal, 0, 8);
        return BitConverter.toDouble(aVal);
    }

    protected static byte readByte(ByteArrayInputStream ms) throws IOException {
        AbstractTriTciClass.checkEnoughBytes(ms, 1);
        return (byte)ms.read();
    }

    protected static void writeStream(ByteArrayOutputStream ms, byte[] aData) {
        int nLen = aData == null ? -1 : aData.length;
        AbstractTriTciClass.writeInt(ms, nLen);
        if (nLen > 0) {
            ms.write(aData, 0, aData.length);
        }
    }

    protected static byte[] readStream(ByteArrayInputStream ms) throws IOException {
        byte[] aData = null;
        int nLen = AbstractTriTciClass.readInt(ms);
        if (nLen == 0) {
            aData = new byte[]{};
        } else if (nLen > 0) {
            AbstractTriTciClass.checkEnoughBytes(ms, nLen);
            aData = new byte[nLen];
            ms.read(aData, 0, nLen);
        }
        return aData;
    }

    protected static void writeUString(ByteArrayOutputStream ms, String s) {
        byte[] aData = null;
        if (s != null && s.length() > 0) {
            try {
                aData = s.getBytes("UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        AbstractTriTciClass.writeStream(ms, aData);
    }

    protected static String readUString(ByteArrayInputStream ms) throws IOException {
        String s = null;
        byte[] aData = AbstractTriTciClass.readStream(ms);
        if (aData != null) {
            s = new String(aData, "UTF-16LE");
        }
        return s;
    }

    protected static String readOptUString(ByteArrayInputStream ms) throws IOException {
        String s = null;
        byte[] aData = AbstractTriTciClass.readStream(ms);
        if (aData != null && aData.length > 0) {
            s = new String(aData, "UTF-16LE");
        }
        return s;
    }

    protected static void writeString(ByteArrayOutputStream ms, String s) {
        byte[] aData = null;
        if (s != null && s.length() > 0) {
            try {
                aData = s.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        AbstractTriTciClass.writeStream(ms, aData);
    }

    protected static String readString(ByteArrayInputStream ms) throws IOException {
        String s = null;
        byte[] aData = AbstractTriTciClass.readStream(ms);
        if (aData != null) {
            s = new String(aData);
        }
        return s;
    }

    protected void writeOptionalObject(AbstractTriTciClass obj, ByteArrayOutputStream ms) {
        AbstractTriTciClass.writeBool(ms, obj != null);
        if (obj != null) {
            obj.serialize(ms);
        }
    }

    protected <T extends AbstractTriTciClass> T readOptionalObject(ByteArrayInputStream ms, Class<T> cls) throws IOException {
        AbstractTriTciClass res = null;
        if (AbstractTriTciClass.readBool(ms)) {
            try {
                res = (AbstractTriTciClass)cls.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (res != null) {
                res.deserialize(ms);
            }
        }
        return (T)res;
    }

    public abstract void serialize(ByteArrayOutputStream var1);

    protected abstract void deserializeProc(ByteArrayInputStream var1) throws IOException;

    public boolean deserialize(ByteArrayInputStream ms) {
        try {
            this.deserializeProc(ms);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

