package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class TestDiff_005_fixed_no_fraction {
	public static final String FOLDER = "xml/005_real";
	public static String XSD_FILE = "005_real_item.xsd";
	public static String FILE_fraction = "02_fixed_fraction.xml";
	public static String FILE_fraction_0 = "02_fixed_fraction_0.xml";
	public static String FILE_fraction_00 = "02_fixed_fraction_00.xml";
	public static final String FILE_base = FILE_fraction;
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File(FOLDER);
		differ = new XmlDiff(
				new File(root, FILE_base), 
				new String[]{XSD_FILE},
				new String[]{FOLDER});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_self() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_base));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_0() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_fraction_0));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

	@Test
	public void test_00() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_fraction_00));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}
}
