package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class TestDiff_004_boolean {
	public static final String FOLDER = "xml/004_boolean";
	public static String XSD_FILE = "004_boolean_item.xsd";
	public static String FILE_with_true = "boolean_true.xml";
	public static String FILE_with_1 = "boolean_1.xml";
	public static String FILE_base = FILE_with_true;
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File(FOLDER);
		differ = new XmlDiff(
				new File(root, FILE_base), 
				new String[]{XSD_FILE},
				new String[]{FOLDER});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_self() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_base));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_1_to_true() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_with_1));
		
		boolean v = differ.diff(actual, errors);
		
		assertFalse(v);
	}
}
