package org.etsi.mts.ttcn.part9.xmldiff;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import org.junit.Test;

public class TestDiff_006 {
	public static final String FOLDER = "xml/006_bug";
	public static final String REFERENCE_XML = "Pos_060307_unsigned_long_001.xml";
	public static final String XSD = "Pos_060307_unsigned_long_001.xsd";
	public static final String TEST_XML_TEXT = 
			"<types:e1 xmlns:types=\"schema:Pos_060307_unsigned_long_001\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">18446744073709551615</types:e1>";
	
	@Test
	public void test_generated() throws IOException, XmlDiffError {
		XmlDiff differ = new XmlDiff(FOLDER + "/" + REFERENCE_XML, 
				new String[]{XSD}, new String[]{FOLDER});
		
		StringBuilder error = new StringBuilder();
		boolean v = differ.diff(TEST_XML_TEXT, error);
		
		assertEquals("", error.toString());
		assertTrue("The XML files must be considered similar", v);
	}

}
