package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class TestDiff_003 {
	public static String XSD_FILE = "003_grammar.xsd";
	public static String FILE_without_ns = "xml_without_ns.xml";
	public static String FILE_with_ns = "xml_with_ns.xml";
	public static String FILE_base = FILE_without_ns;
	public static String FILE_ttwb = "generated_ttwb.xml";
	public static String FILE_tc = "generated_tc.xml";
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File("xml/003");
		differ = new XmlDiff(new File(root, FILE_base), new String[]{XSD_FILE},
				new String[]{"xml/003"});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_self() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_base));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_ttwb() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_ttwb));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test(expected=XmlDiffError.class)
	public void test_tc() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_tc));
		
		boolean v = differ.diff(actual, errors);
		
		assertFalse(v);
		assertTrue(errors.toString().contains("attribute"));
	}

	@Test
	public void test_nons_vs_withns() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_without_ns));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}
}
