package org.etsi.mts.ttcn.part9.xmldiff;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogUtil {
	public final Logger logger;

	public LogUtil(Logger logger) {
		super();
		this.logger = logger;
	}

	private void _log(Level lvl, Object... args) {
		if (!logger.isLoggable(lvl)) return;
		
		StringBuilder msg = new StringBuilder();
		StackTraceElement[] trace = Thread.currentThread().getStackTrace();
		StackTraceElement caller = null;
		if (trace.length > 3) {
			caller = trace[3];
		}
		if (caller != null) {
			msg.append(caller.getFileName()).append(':');
			msg.append(caller.getLineNumber()).append(':');
//			msg.append(caller.getClassName()).append(':');
//			msg.append(caller.getMethodName()).append(':');
		}
		
		for (Object arg : args) {
			msg.append(arg);
		}
		LogRecord record = new LogRecord(lvl, msg.toString());
		if (caller != null) {
			record.setSourceClassName(caller.getClassName());
			record.setSourceMethodName(caller.getMethodName());
		}
		logger.log(record);
		
	}
	
	public void severe(Object... args) {
		_log(Level.SEVERE, args);
	}
	public void warning(Object... args) {
		_log(Level.WARNING, args);
	}
	public void config(Object... args) {
		_log(Level.CONFIG, args);
	}
	public void info(Object... args) {
		_log(Level.INFO, args);
	}
	public void debug(Object... args) {
		_log(Level.FINE, args);
	}
	public void debug2(Object... args) {
		_log(Level.FINER, args);
	}
	public void debug3(Object... args) {
		_log(Level.FINEST, args);
	}
}
