import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;


public class TestCastProjectBuilder {
	private String files = "";
	private String sut = "";
	
	private String template1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + 
	"<solution>\n" + 
	" <scripts>\n" + 
	"  <items>\n"; 
	
	private String template2 = 
		"  </items>\n" + 
		" </scripts>\n" + 
		" <verstool />\n"; 

	private String template3 = 
	" <ExternalAttributeFiles>\n" + 
	"  <items />\n" + 
	" </ExternalAttributeFiles>\n" + 
	" <ModuleParFiles>\n" + 
	"  <items />\n" + 
	" </ModuleParFiles>\n" + 
	" <TestcaseSelections>\n" + 
	"  <items />\n" + 
	" </TestcaseSelections>\n" + 
	" <TestCampaigns>\n" + 
	"  <items />\n" + 
	" </TestCampaigns>\n" + 
	" <ttcn3_settings>\n" + 
	"  <tc_block />\n" + 
	"  <ttcn3_version>Ttcn3_2013</ttcn3_version>\n" + 
	"  <asn>BER</asn>\n" + 
	"  <dll_timeout>10</dll_timeout>\n" + 
	"  <port>7777</port>\n" + 
	"  <ctime>60</ctime>\n" + 
	"  <sa_count>1</sa_count>\n" + 
	"  <rtime>20</rtime>\n" + 
	"  <codec_type>internal</codec_type>\n" + 
	"  <enc>\n" + 
	"   <text>\n" + 
	"    <ifrmt>dec</ifrmt>\n" + 
	"    <char>UTF8</char>\n" + 
	"    <byte_order>le</byte_order>\n" + 
	"    <psep>:</psep>\n" + 
	"    <ws> \\t</ws>\n" + 
	"    <sep>;</sep>\n" + 
	"   </text>\n" + 
	"  </enc>\n" + 
	"  <no_bs_dq />\n" + 
	"  <length-form>definite</length-form>\n" + 
	"  <forbidden_ctrl_warn />\n" + 
	"  <default-step>0.1</default-step>\n" + 
	" </ttcn3_settings>\n" + 
	"</solution>";

	public void addFile(String filename) {
		File f = new File(filename);
		files += "   <script>\n";
		if (filename.endsWith(".xsd"))
			files += "    <name>" + f.getName().substring(0, f.getName().indexOf(".xsd")) + "_xsd</name>\n";
		else
			files += "    <name>" + f.getName().substring(0, f.getName().indexOf(".ttcn")) + "</name>\n";
		files += "    <file>" + filename + "</file>\n"; 
		if (filename.endsWith(".xsd"))
			files += "    <type>xsd</type>\n"; 
		else
			files += "    <type>ttcn3</type>\n"; 
		files += "   </script>\n"; 
	}

	public void setSUT(String sutFile) {
		sut = " <sut>\n";
		sut += "  <exe>\"" + sutFile + "\"</exe>\n";
		sut += " </sut>\n";
	}
	
	public String getProjectFileString() {
		return template1 + files + template2 + sut + template3;
	}
	
	public void saveProjectFile(File f) {
		 PrintWriter out;
		try {
			out = new PrintWriter(new FileWriter(f));
			 out.print(getProjectFileString());
			 out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
