public class Clause implements Comparable<Clause> {
	private Integer mainClause = null;
	private Integer subClause = null;
	private Integer subSubClause = null;
	private Integer subSubSubClause = null;
	private Integer subSubSubSubClause = null;
	private Integer subSubSubSubSubClause = null;
	private Character annex = null;

	public Integer getMainClause() {
		return mainClause;
	}

	public void setMainClause(Integer mainClause) {
		this.mainClause = mainClause;
	}

	public Integer getSubClause() {
		return subClause;
	}

	public void setSubClause(Integer subClause) {
		this.subClause = subClause;
	}

	public Integer getSubSubClause() {
		return subSubClause;
	}

	public void setSubSubClause(Integer subSubClause) {
		this.subSubClause = subSubClause;
	}

	public Integer getSubSubSubClause() {
		return subSubSubClause;
	}

	public void setSubSubSubClause(Integer subSubSubClause) {
		this.subSubSubClause = subSubSubClause;
	}

	public Integer getSubSubSubSubClause() {
		return subSubSubSubClause;
	}

	public void setSubSubSubSubClause(Integer subSubSubSubClause) {
		this.subSubSubSubClause = subSubSubSubClause;
	}

	public Integer getSubSubSubSubSubClause() {
		return subSubSubSubSubClause;
	}

	public void setSubSubSubSubSubClause(Integer subSubSubSubSubClause) {
		this.subSubSubSubSubClause = subSubSubSubSubClause;
	}

	public Character getAnnex() {
		return annex;
	}

	public void setAnnex(Character annex) {
		this.annex = annex;
	}

	public Clause(String clause) {
		String clauseString = clause;
		if (Character.isLetter(clauseString.charAt(0))) { // we start with an
															// annex
			annex = new Character(clauseString.charAt(0));

			if (clause.length() == 1)
				return;

			clauseString = clause.substring(1);
		}
		if (clauseString.charAt(0) == '.') {
			clauseString = clauseString.substring(1);
		}

		if (clauseString.contains(".")) {
			
			String[] parts = clauseString.split("\\.");
			if (parts.length >= 1)
				mainClause = Integer.parseInt(parts[0]);
			if (parts.length >= 2)
				subClause = Integer.parseInt(parts[1]);
			if (parts.length >= 3)
				subSubClause = Integer.parseInt(parts[2]);
			if (parts.length >= 4)
				subSubSubClause = Integer.parseInt(parts[3]);
			if (parts.length >= 5)
				subSubSubSubClause = Integer.parseInt(parts[4]);
			if (parts.length >= 6)
				subSubSubSubSubClause = Integer.parseInt(parts[5]);
		} else {
			mainClause = Integer.parseInt(clauseString);
		}

	}

	public String toString() {
		StringBuffer result = new StringBuffer();

		if (annex != null) {
			result.append(annex);
		}

		if (mainClause != null) {
			if (annex != null)
				result.append(".");
			result.append(mainClause);
		}

		if (subClause != null) {
			result.append(".");
			result.append(subClause);

			if (subSubClause != null) {
				result.append(".");
				result.append(subSubClause);

				if (subSubSubClause != null) {
					result.append(".");
					result.append(subSubSubClause);

					if (subSubSubSubClause != null) {
						result.append(".");
						result.append(subSubSubSubClause);

						if (subSubSubSubSubClause != null) {
							result.append(".");
							result.append(subSubSubSubSubClause);
						}
					}
				}
			}
		}

		return result.toString();
	}

	@Override
	public int compareTo(Clause y) {
		if ((annex != null) && (y.getAnnex() == null)) {
			return +1;
		}
		if ((annex == null) && (y.getAnnex() != null)) {
			return -1;
		}

		if ((annex != null) && (y.getAnnex() != null)
				&& (!annex.equals(y.getAnnex()))) {
			if (annex > y.getAnnex()) {
				return +1;
			} else {
				return -1;
			}
		}

		if (((annex == null) && (y.getAnnex() == null))
				|| (annex.equals(y.getAnnex()))) {
			if (annex != null && y.getAnnex() != null
					&& annex.equals(y.getAnnex()) && mainClause == null
					&& y.getMainClause() != null)
				return -1;

			if (annex != null && y.getAnnex() != null
					&& annex.equals(y.getAnnex()) && mainClause != null
					&& y.getMainClause() == null)
				return +1;

			if (mainClause > y.getMainClause()) {
				return +1;
			}
			if (mainClause < y.getMainClause()) {
				return -1;
			}

			if ((mainClause != null) && (y.getMainClause() != null)) {
				if (mainClause.equals(y.getMainClause())) {
					if ((subClause == null) && (y.getSubClause() != null))
						return -1;
					if ((subClause != null) && (y.getSubClause() == null))
						return +1;

					if (subClause > y.getSubClause()) {
						return +1;
					}
					if (subClause < y.getSubClause()) {
						return -1;
					}

					if (subClause.equals(y.getSubClause())) {
						if ((subSubClause == null)
								&& (y.getSubSubClause() != null))
							return -1;
						if ((subSubClause != null)
								&& (y.getSubSubClause() == null))
							return +1;

						if (subSubClause > y.getSubSubClause()) {
							return +1;
						}
						if (subSubClause < y.getSubSubClause()) {
							return -1;
						}

						if (subSubClause.equals(y.getSubSubClause())) {
							if ((subSubSubClause == null)
									&& (y.getSubSubSubClause() != null))
								return -1;
							if ((subSubSubClause != null)
									&& (y.getSubSubSubClause() == null))
								return +1;

							if (subSubSubClause > y.getSubSubSubClause()) {
								return +1;
							}
							if (subSubSubClause < y.getSubSubSubClause()) {
								return -1;
							}

							if (subSubSubClause.equals(y.getSubSubSubClause())) {
								if ((subSubSubSubClause == null)
										&& (y.getSubSubSubSubClause() != null))
									return -1;
								if ((subSubSubSubClause != null)
										&& (y.getSubSubSubSubClause() == null))
									return +1;

								if (subSubSubSubClause > y
										.getSubSubSubSubClause()) {
									return +1;
								}
								if (subSubSubSubClause < y
										.getSubSubSubSubClause()) {
									return -1;
								}

								if (subSubSubSubClause.equals(y
										.getSubSubSubSubClause())) {
									if ((subSubSubSubSubClause == null)
											&& (y.getSubSubSubSubSubClause() != null))
										return -1;
									if ((subSubSubSubSubClause != null)
											&& (y.getSubSubSubSubSubClause() == null))
										return +1;

									if (subSubSubSubSubClause > y
											.getSubSubSubSubSubClause()) {
										return +1;
									}
									if (subSubSubSubSubClause < y
											.getSubSubSubSubSubClause()) {
										return -1;
									}

									return 0;
								}

							}

						}

					}
				}
			}

			return 0;
		}

		return 0;
	}

}
