/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciParameterList;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciParameterRefList;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriFunctionIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.xtri.xTriPlatformPA;

class XTriExternalFunctionMessage
extends AbstractTriTciMessage {
    private TriFunctionIdImpl m_funcId;
    private TciParameterRefList m_paramRefList;
    private TciValueRef m_retVal;

    public XTriExternalFunctionMessage() {
        this.m_funcId = new TriFunctionIdImpl();
        this.m_paramRefList = new TciParameterRefList();
    }

    public XTriExternalFunctionMessage(TriFunctionIdImpl funcId, TciParameterRefList paramList, TciValueRef retVal) {
        this.m_funcId = funcId;
        this.m_paramRefList = paramList;
        this.m_retVal = retVal;
    }

    public TriFunctionIdImpl getFunctionId() {
        return this.m_funcId;
    }

    public TciParameterRefList getParameterRefList() {
        return this.m_paramRefList;
    }

    public TciValueRef getReturnValue() {
        return this.m_retVal;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_funcId.serialize(ms);
        this.m_paramRefList.serialize(ms);
        this.serializeOptionalTciValue(this.m_retVal, ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_funcId.deserialize(ms);
        this.m_paramRefList.deserialize(ms);
        this.m_retVal = this.deserializeOptionalTciValue(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.XExternalFunction;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new XTriExternalFunctionMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() instanceof xTriPlatformPA;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ExternalTciParameterList list = new ExternalTciParameterList(this.m_paramRefList);
        ExternalTciValue retVal = null;
        if (this.m_retVal != null) {
            retVal = this.m_retVal.createValue();
        }
        TriStatus status = ((xTriPlatformPA)((Object)TriProvider.getInstance().getTriPlatformPA())).xtriExternalFunction(this.m_funcId, list, retVal);
        return new AdapterProcessingResult(status);
    }
}

