/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriTciChannel;
import org.elvior.ttcn.tritci.ValueReply;
import org.elvior.ttcn.tritci.XTriObjectMessage;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.xtri.xTriCommunicationSA;

class XTriConvertMessage
extends XTriObjectMessage {
    private long m_nTypeId;

    public XTriConvertMessage() {
    }

    public XTriConvertMessage(long nObjectId, long nTypeId) {
        super(nObjectId);
        this.m_nTypeId = nTypeId;
    }

    public ExternalTciType createType() {
        return new ExternalTciType(this.m_nTypeId);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        XTriConvertMessage.writeLong(ms, this.m_nTypeId);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_nTypeId = XTriConvertMessage.readLong(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new XTriConvertMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.XConvert;
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() instanceof xTriCommunicationSA;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriStatusImpl.ok();
        TciValueRef valRef = null;
        try {
            ExternalTciType typeHypothesis = this.createType();
            Object o = TriTciChannel.getInstance().getRegisteredObject(this.getId());
            if (o != null) {
                Value val = ((xTriCommunicationSA)((Object)TriProvider.getInstance().getTriCommunicationSA())).xtriConvert(o, typeHypothesis);
                if (val instanceof ExternalTciValue) {
                    ExternalTciValue tciVal = (ExternalTciValue)val;
                    valRef = tciVal.toValueRef();
                } else {
                    status = TriStatusImpl.error();
                }
            }
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        ValueReply ack = new ValueReply(valRef, status.getStatus());
        return new AdapterProcessingResult(status, ack);
    }
}

