/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriTimerDurationImpl;
import org.elvior.ttcn.tritci.TriTimerIdImpl;
import org.etsi.ttcn.tri.TriStatus;

class TriTimerStartMessage
extends AbstractTriTciMessage {
    private TriTimerIdImpl m_timerId;
    private TriTimerDurationImpl m_timerDuration;

    public TriTimerStartMessage(TriTimerIdImpl timerId, TriTimerDurationImpl timerDuration) {
        this.m_timerId = timerId;
        this.m_timerDuration = timerDuration;
    }

    public TriTimerStartMessage() {
        this.m_timerId = new TriTimerIdImpl();
        this.m_timerDuration = new TriTimerDurationImpl();
    }

    public TriTimerIdImpl getTimerId() {
        return this.m_timerId;
    }

    public TriTimerDurationImpl getDuration() {
        return this.m_timerDuration;
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TimerStart;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_timerId.deserialize(ms);
        this.m_timerDuration.deserialize(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_timerId.serialize(ms);
        this.m_timerDuration.serialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriTimerStartMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriPlatformPA().triStartTimer(this.m_timerId, this.m_timerDuration);
        return new AdapterProcessingResult(status);
    }
}

