/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriCommOperation;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriEncodedDataReply;
import org.elvior.ttcn.tritci.TriMessageImpl;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriStatusRead;
import org.etsi.ttcn.tri.TriStatus;

class TriReadStatusMessage
extends AbstractTriCommOperation {
    private TriMessageImpl m_param;

    public TriReadStatusMessage() {
    }

    public TriReadStatusMessage(TriComponentIdImpl comp, TriPortIdImpl systemPort, TriMessageImpl msg) {
        super(comp, systemPort);
        this.m_param = msg;
    }

    public TriMessageImpl getStatusParam() {
        return this.m_param;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        if (this.m_param != null) {
            TriReadStatusMessage.writeBool(ms, true);
            this.m_param.serialize(ms);
        } else {
            TriReadStatusMessage.writeBool(ms, false);
        }
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        if (TriReadStatusMessage.readBool(ms)) {
            this.m_param = new TriMessageImpl();
            this.m_param.deserialize(ms);
        }
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriReadStatusMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.ReadStatus;
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() instanceof TriStatusRead;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriStatusImpl.ok();
        TriMessageImpl portStatus = new TriMessageImpl();
        try {
            status = ((TriStatusRead)((Object)TriProvider.getInstance().getTriCommunicationSA())).triRead(this.getComponentId(), this.getSystemPortId(), this.m_param, portStatus);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        TriEncodedDataReply ack = new TriEncodedDataReply(status.getStatus(), portStatus);
        return new AdapterProcessingResult(status, ack);
    }
}

