/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.LongIntReply;
import org.elvior.ttcn.tritci.TriLongImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tri.TriStatus;

class TriReadClockMessage
extends AbstractTriTciMessage {
    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status;
        long nRes = 0L;
        try {
            TriLongImpl longVal = new TriLongImpl();
            status = TriProvider.getInstance().getTriPlatformPA().triReadClock(longVal);
            nRes = longVal.getLongValue();
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        LongIntReply ack = new LongIntReply(nRes, status.getStatus());
        return new AdapterProcessingResult(status, ack);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriReadClockMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.ReadClock;
    }
}

