/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.etsi.ttcn.tri.TriParameter;

class TriParameterImpl
extends AbstractTriTciClass
implements TriParameter {
    private String m_sParamName;
    private byte[] m_aData;
    private int m_nPassingMode;
    private int m_nBits;

    public TriParameterImpl() {
    }

    public TriParameterImpl(String sParamName, int passingMode, byte[] aEncodedData) {
        this(sParamName, passingMode, aEncodedData, aEncodedData == null ? 0 : aEncodedData.length * 8);
    }

    public TriParameterImpl(String sParamName, int passingMode, byte[] aEncodedData, int nBitLen) {
        this.m_sParamName = sParamName;
        this.m_nPassingMode = passingMode;
        this.m_aData = aEncodedData;
        this.m_nBits = nBitLen;
    }

    public TriParameterImpl(TriParameter src) {
        this.m_sParamName = src.getParameterName();
        this.m_nPassingMode = src.getParameterPassingMode();
        this.m_aData = src.getEncodedParameter();
        this.m_nBits = src.getNumberOfBits();
    }

    @Override
    public byte[] getEncodedParameter() {
        return this.m_aData;
    }

    @Override
    public String getParameterName() {
        return this.m_sParamName;
    }

    @Override
    public int getParameterPassingMode() {
        return this.m_nPassingMode;
    }

    @Override
    public void setEncodedParameter(byte[] parameter) {
        this.m_aData = parameter;
        this.m_nBits = this.m_aData == null ? 0 : this.m_aData.length * 8;
    }

    @Override
    public void setParameterName(String name) {
        this.m_sParamName = name;
    }

    @Override
    public void setParameterPassingMode(int mode) {
        this.m_nPassingMode = mode;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        int nVal;
        this.m_nPassingMode = nVal = ms.read();
        this.m_sParamName = TriParameterImpl.readString(ms);
        this.m_aData = TriParameterImpl.readStream(ms);
        this.m_nBits = TriParameterImpl.readInt(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        byte yVal = (byte)this.m_nPassingMode;
        ms.write(yVal);
        TriParameterImpl.writeString(ms, this.m_sParamName);
        TriParameterImpl.writeStream(ms, this.m_aData);
        TriParameterImpl.writeInt(ms, this.m_nBits);
    }

    @Override
    public int getNumberOfBits() {
        return this.m_nBits;
    }

    @Override
    public void setNumberOfBits(int amount) {
        this.m_nBits = amount;
    }
}

