/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriFunctionAckMessage;
import org.elvior.ttcn.tritci.TriFunctionIdImpl;
import org.elvior.ttcn.tritci.TriParameterImpl;
import org.elvior.ttcn.tritci.TriParameterListImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tri.TriParameter;
import org.etsi.ttcn.tri.TriStatus;

class TriExternalFunctionMessage
extends AbstractTriTciMessage {
    private TriFunctionIdImpl m_funcId;
    private TriParameterListImpl m_paramList;

    public TriExternalFunctionMessage(TriFunctionIdImpl funcId, TriParameterListImpl paramList) {
        this.m_funcId = funcId;
        this.m_paramList = paramList;
    }

    public TriExternalFunctionMessage() {
        this.m_funcId = new TriFunctionIdImpl();
        this.m_paramList = new TriParameterListImpl();
    }

    public TriFunctionIdImpl getFunctionId() {
        return this.m_funcId;
    }

    public TriParameterListImpl getParameters() {
        return this.m_paramList;
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.ExternalFunction;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_funcId.deserialize(ms);
        this.m_paramList.deserialize(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_funcId.serialize(ms);
        this.m_paramList.serialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriExternalFunctionMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status;
        TriParameterImpl returnValue = new TriParameterImpl(null, 2, null);
        try {
            status = TriProvider.getInstance().getTriPlatformPA().triExternalFunction(this.m_funcId, this.m_paramList, returnValue);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        TriParameterListImpl paramList = new TriParameterListImpl();
        int i = 0;
        while (i < this.m_paramList.size()) {
            TriParameter param = this.m_paramList.get(i);
            if (param.getParameterPassingMode() != 0) {
                paramList.add(param);
            }
            ++i;
        }
        TriFunctionAckMessage ack = new TriFunctionAckMessage(status.getStatus(), paramList, returnValue);
        return new AdapterProcessingResult(status, ack);
    }
}

