/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriPortIdListImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriTestCaseIdImpl;
import org.etsi.ttcn.tri.TriPortIdList;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.tri.TriTestCaseId;

class TriExecuteTestCaseMessage
extends AbstractTriTciMessage {
    private TriTestCaseIdImpl m_testCaseId;
    private TriPortIdListImpl m_ports;

    public TriExecuteTestCaseMessage() {
        this.m_testCaseId = new TriTestCaseIdImpl();
        this.m_ports = new TriPortIdListImpl();
    }

    public TriExecuteTestCaseMessage(TriTestCaseIdImpl testCaseId, TriPortIdListImpl ports) {
        this.m_testCaseId = testCaseId;
        this.m_ports = ports;
    }

    public TriTestCaseId getTestCaseId() {
        return this.m_testCaseId;
    }

    public TriPortIdList getPortIdList() {
        return this.m_ports;
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.ExecuteTestCase;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_testCaseId.deserialize(ms);
        this.m_ports.deserialize(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_testCaseId.serialize(ms);
        this.m_ports.serialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriExecuteTestCaseMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriCommunicationSA().triExecuteTestCase(this.m_testCaseId, this.m_ports);
        return new AdapterProcessingResult(status);
    }
}

