/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TliStringMessage;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriStatusImpl;

class TliInfoMessage
extends TliStringMessage {
    private int m_nLevel;

    public TliInfoMessage(String am, long ts, String src, int line, TriComponentIdImpl c, int nLevel, String sInfo) {
        super(am, ts, src, line, c, sInfo);
        this.m_nLevel = nLevel;
    }

    public TliInfoMessage() {
    }

    public int getLevel() {
        return this.m_nLevel;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TliInfoMessage.writeInt(ms, this.m_nLevel);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_nLevel = TliInfoMessage.readInt(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TliInfoMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TliInfo;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        if (!this.isSupportedInAdapter()) {
            return new AdapterProcessingResult(TriStatusImpl.error());
        }
        TciProvider.getInstance().getTciTLProvided().tliInfo(this.getDetails(), this.getTimeStampInSeconds(), this.getFile(), this.getLine(), this.getComponentId(), this.getLevel(), this.getText());
        return new AdapterProcessingResult(TriStatusImpl.ok());
    }
}

