/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciParameterList;
import org.elvior.ttcn.tritci.TciParameterRefList;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciTestCaseParamMessage;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tci.TciTestCaseId;

class TciTestCaseStartedMessage
extends TciTestCaseParamMessage {
    private double m_fTimer = Double.POSITIVE_INFINITY;

    public TciTestCaseStartedMessage(TciTestCaseId tc, TciParameterRefList paramList, double timer) {
        super(tc, paramList);
        this.m_fTimer = timer;
    }

    public TciTestCaseStartedMessage() {
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TestCaseStarted;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciTestCaseStartedMessage();
    }

    public double getTimer() {
        return this.m_fTimer;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TciTestCaseStartedMessage.writeDouble(ms, this.m_fTimer);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_fTimer = TciTestCaseStartedMessage.readDouble(ms);
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TciProvider.getInstance().getTciTMProvided() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TciProvider.getInstance().getTciTMProvided().tciTestCaseStarted(this.getTestCase(), new ExternalTciParameterList(this.getParameterList()), (float)this.m_fTimer);
        return new AdapterProcessingResult(TriStatusImpl.ok());
    }
}

