/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciEncodeReply;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tri.TriMessage;

class TciEncodeMessage
extends AbstractTriTciMessage {
    TciValueRef m_valRef;

    public TciEncodeMessage(TciValueRef valRef) {
        this.m_valRef = valRef;
    }

    public TciEncodeMessage() {
    }

    public TciValueRef getValueReference() {
        return this.m_valRef;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciEncodeMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.Encode;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_valRef.serialize(ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_valRef = new TciValueRef();
        this.m_valRef.deserialize(ms);
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TciProvider.getInstance().getTciCDProvided() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ExternalTciValue extVal = this.m_valRef.createValue();
        TriMessage encoded = null;
        try {
            encoded = TciProvider.getInstance().getTciCDProvided().encode(extVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TciEncodeReply ack = new TciEncodeReply(encoded, encoded == null ? -1 : 0);
        return new AdapterProcessingResult(TriStatusImpl.ok(), ack);
    }
}

