/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTciObjectMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriMessageExImpl;
import org.elvior.ttcn.tritci.TriMessageImpl;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.ValueReply;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriMessage;
import org.etsi.ttcn.tri.TriStatus;

class TciDecodeMessage
extends AbstractTciObjectMessage {
    private TriMessageExImpl m_msg;

    public TciDecodeMessage(TriMessage message, long nTypeId) {
        super(nTypeId);
        if (message == null) {
            throw new NullPointerException();
        }
        this.m_msg = message instanceof TriMessageExImpl ? (TriMessageExImpl)message : new TriMessageExImpl(message);
    }

    public TciDecodeMessage() {
        super(0L);
    }

    public TriMessageImpl getMessage() {
        return this.m_msg;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciDecodeMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.Decode;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_msg.serialize(ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_msg = new TriMessageExImpl();
        this.m_msg.deserialize(ms);
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TciProvider.getInstance().getTciCDProvided() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ValueReply ack;
        ExternalTciType type = new ExternalTciType(this.getId());
        Value val = null;
        TriStatus status = TriStatusImpl.ok();
        try {
            val = TciProvider.getInstance().getTciCDProvided().decode(this.m_msg, type);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        if (val instanceof ExternalTciValue) {
            ExternalTciValue extVal = (ExternalTciValue)val;
            ack = new ValueReply(new TciValueRef(extVal.getId(), extVal.getType().getTypeClass()), this.m_msg.getBitPosition(), 0);
        } else {
            ack = val == null ? new ValueReply(null, status.getStatus()) : new ValueReply(null, -1);
        }
        return new AdapterProcessingResult(status, ack);
    }
}

