/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriAckMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.ETriTciMessageCode;

class StringArrayReply
extends AbstractTriAckMessage {
    private String[] m_asValues;

    public StringArrayReply(String[] asValues, int nStatus) {
        super(nStatus);
        this.m_asValues = asValues;
    }

    public StringArrayReply() {
    }

    public String[] getValues() {
        return this.m_asValues;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new StringArrayReply();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.StringArrayReply;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        int nLen = -1;
        if (this.m_asValues != null) {
            nLen = this.m_asValues.length;
        }
        StringArrayReply.writeInt(ms, nLen);
        int i = 0;
        while (i < nLen) {
            StringArrayReply.writeString(ms, this.m_asValues[i]);
            ++i;
        }
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_asValues = null;
        int nLen = StringArrayReply.readInt(ms);
        if (nLen >= 0) {
            this.m_asValues = new String[nLen];
        }
        int i = 0;
        while (i < nLen) {
            this.m_asValues[i] = StringArrayReply.readString(ms);
            ++i;
        }
    }
}

