/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.etsi.ttcn.tri.QualifiedName;

class QualifiedNameImpl
extends AbstractTriTciClass
implements QualifiedName {
    private String m_sModuleName;
    private String m_sBaseName;

    public QualifiedNameImpl(String sModuleName, String sBaseName) {
        this.m_sModuleName = sModuleName;
        this.m_sBaseName = sBaseName;
    }

    public QualifiedNameImpl(String sDotNotation) {
        int nIndex = sDotNotation.indexOf(46);
        if (nIndex >= 0) {
            this.m_sModuleName = sDotNotation.substring(0, nIndex);
            this.m_sBaseName = sDotNotation.substring(nIndex + 1);
        } else {
            this.m_sBaseName = sDotNotation;
        }
    }

    public QualifiedNameImpl(QualifiedName src) {
        this.m_sModuleName = src.getModuleName();
        this.m_sBaseName = src.getBaseName();
    }

    public QualifiedNameImpl() {
    }

    @Override
    public String getModuleName() {
        return this.m_sModuleName;
    }

    @Override
    public String getBaseName() {
        return this.m_sBaseName;
    }

    public boolean equals(QualifiedName name) {
        return !(this.m_sBaseName != name.getBaseName() && !this.m_sBaseName.equals(name.getBaseName()) || this.m_sModuleName != name.getModuleName() && !this.m_sModuleName.equals(name.getModuleName()));
    }

    public int hashCode() {
        if (this.m_sModuleName == null) {
            if (this.m_sBaseName == null) {
                return 0;
            }
            return this.m_sBaseName.hashCode();
        }
        if (this.m_sBaseName == null) {
            return this.m_sModuleName.hashCode();
        }
        String s = String.valueOf(this.m_sModuleName) + this.m_sBaseName;
        return s.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)obj;
            return this.equals(qn);
        }
        return false;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        String s = this.m_sBaseName;
        if (this.m_sModuleName != null) {
            s = String.valueOf(this.m_sModuleName) + "." + s;
        }
        QualifiedNameImpl.writeString(ms, s);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        String s = QualifiedNameImpl.readString(ms);
        if (s != null) {
            int nIndex = s.indexOf(46);
            this.m_sModuleName = s.substring(0, nIndex);
            this.m_sBaseName = s.substring(nIndex + 1);
        } else {
            this.m_sBaseName = s;
        }
    }

    public String toString() {
        String sRes = this.m_sBaseName;
        if (this.m_sModuleName != null && this.m_sModuleName.length() > 0) {
            sRes = String.valueOf(this.m_sModuleName) + "." + this.m_sBaseName;
        }
        return sRes;
    }
}

