/*
 * Decompiled with CFR 0.152.
 */
package com.elvior.adapter.loopbackpart9;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.elvior.ttcn.tritci.ChannelEventHandler;
import org.elvior.ttcn.tritci.TriFactory;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriTciChannel;
import org.etsi.mts.ttcn.part9.xmldiff.XmlDiff;
import org.etsi.ttcn.tci.BooleanValue;
import org.etsi.ttcn.tci.RecordOfValue;
import org.etsi.ttcn.tci.TciParameterList;
import org.etsi.ttcn.tci.UniversalCharstringValue;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriAddress;
import org.etsi.ttcn.tri.TriAddressList;
import org.etsi.ttcn.tri.TriBoolean;
import org.etsi.ttcn.tri.TriCommunicationSA;
import org.etsi.ttcn.tri.TriComponentId;
import org.etsi.ttcn.tri.TriException;
import org.etsi.ttcn.tri.TriFunctionId;
import org.etsi.ttcn.tri.TriLong;
import org.etsi.ttcn.tri.TriMessage;
import org.etsi.ttcn.tri.TriParameter;
import org.etsi.ttcn.tri.TriParameterList;
import org.etsi.ttcn.tri.TriPlatformPA;
import org.etsi.ttcn.tri.TriPortId;
import org.etsi.ttcn.tri.TriPortIdList;
import org.etsi.ttcn.tri.TriSignatureId;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.tri.TriTestCaseId;
import org.etsi.ttcn.tri.TriTimerDuration;
import org.etsi.ttcn.tri.TriTimerId;
import org.etsi.ttcn.xtri.xTriPlatformPA;

public class Adapter
implements TriCommunicationSA,
TriPlatformPA,
ChannelEventHandler,
xTriPlatformPA {
    private TriStatus m_ok;
    private TriStatus m_error;
    private String m_testCaseName;

    public static void main(String[] args) {
        Adapter app = new Adapter();
        app.run();
    }

    private Adapter() {
        TriProvider.getInstance().setTriCommunicationSA(this);
        TriProvider.getInstance().setTriPlatformPA(this);
        TriTciChannel channel = TriTciChannel.getInstance();
        channel.setApplicationName("Loopback Adapter for Part 9 Testing");
        channel.setEventHandler(this);
        TriFactory factory = TriProvider.getInstance().getTriFactory();
        this.m_ok = factory.createOkStatus();
        this.m_error = factory.createErrorStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        if (TriTciChannel.getInstance().open()) {
            try {
                Adapter adapter = this;
                synchronized (adapter) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void log(String s) {
        System.out.println(s);
    }

    @Override
    public void onError(String sErrorDescription) {
        this.log("TRI error occured: " + sErrorDescription);
    }

    @Override
    public void onConnectionEstablished() {
        this.log("TRI connection established");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionClosed() {
        this.log("TRI connection closed");
        Adapter adapter = this;
        synchronized (adapter) {
            this.notify();
        }
    }

    @Override
    public TriStatus triPAReset() {
        return this.m_ok;
    }

    @Override
    public TriStatus triStartTimer(TriTimerId timerId, TriTimerDuration timerDuration) {
        return this.m_ok;
    }

    @Override
    public TriStatus triStopTimer(TriTimerId timerId) {
        return this.m_ok;
    }

    @Override
    public TriStatus triReadTimer(TriTimerId timerId, TriTimerDuration elapsedTime) {
        return this.m_ok;
    }

    @Override
    public TriStatus triTimerRunning(TriTimerId timerId, TriBoolean running) {
        return this.m_ok;
    }

    @Override
    public TriStatus triExternalFunction(TriFunctionId functionId, TriParameterList parameterList, TriParameter returnValue) {
        TriStatus status = this.m_ok;
        String funcName = functionId.getFunctionName();
        int index = funcName.indexOf(46);
        if (index >= 0) {
            funcName = funcName.substring(index + 1);
        }
        if (funcName.equals("matchFile")) {
            String stringToMatch = "";
            String referenceXmlFile = "";
            String[] xsdSearchPath = null;
            try {
                stringToMatch = new String(parameterList.get(0).getEncodedParameter(), "UTF-8");
                referenceXmlFile = new String(parameterList.get(1).getEncodedParameter(), "UTF-8");
                String xsdFileList = new String(parameterList.get(2).getEncodedParameter(), "UTF-8");
                if (xsdFileList.length() > 0) {
                    xsdSearchPath = xsdFileList.split(";");
                }
            }
            catch (Exception e) {
                return this.m_error;
            }
            String description = null;
            boolean res = false;
            try {
                XmlDiff diff = new XmlDiff(referenceXmlFile, xsdSearchPath, null);
                StringBuilder sb = new StringBuilder();
                res = diff.diff(stringToMatch, sb);
                if (sb.length() > 0) {
                    description = sb.toString();
                }
            }
            catch (Exception e) {
                description = e.getMessage();
            }
            if (!res && description == null) {
                description = "\u00dcnspecified error";
            }
            if (!res) {
                parameterList.get(3).setEncodedParameter(description.getBytes(Charset.forName("UTF-8")));
            }
            String resultText = res ? "true" : "false";
            returnValue.setEncodedParameter(resultText.getBytes(Charset.forName("UTF-8")));
        } else {
            status = this.m_error;
        }
        return status;
    }

    @Override
    public TriStatus triStartClock(long ticksPerSecond) {
        return this.m_ok;
    }

    @Override
    public TriStatus triReadClock(TriLong timepoint) {
        return this.m_ok;
    }

    @Override
    public TriStatus triNextSampling(long timepoint, TriPortId port) {
        return this.m_ok;
    }

    @Override
    public TriStatus triBeginWait(long timepoint, TriComponentId component) {
        return this.m_ok;
    }

    @Override
    public TriStatus triSAReset() {
        return this.m_ok;
    }

    @Override
    public TriStatus triExecuteTestCase(TriTestCaseId testCaseId, TriPortIdList tsiPorts) {
        this.m_testCaseName = testCaseId.getTestCaseName();
        this.log("Test case " + this.m_testCaseName + " has started.");
        return this.m_ok;
    }

    @Override
    public TriStatus triMap(TriPortId compPortId, TriPortId tsiPortId) {
        return this.m_ok;
    }

    @Override
    public TriStatus triMapParam(TriPortId compPortId, TriPortId tsiPortId, TriParameterList paramList) {
        return this.m_ok;
    }

    @Override
    public TriStatus triUnmap(TriPortId compPortId, TriPortId tsiPortId) {
        return this.m_ok;
    }

    @Override
    public TriStatus triUnmapParam(TriPortId compPortId, TriPortId tsiPortId, TriParameterList paramList) {
        return this.m_ok;
    }

    @Override
    public TriStatus triEndTestCase() {
        this.log("Test case " + this.m_testCaseName + " has ended.");
        return this.m_ok;
    }

    @Override
    public TriStatus triSend(TriComponentId componentId, TriPortId tsiPortId, TriAddress address, TriMessage message) {
        TriProvider.getInstance().getTriCommunicationTE().triEnqueueMsg(tsiPortId, address, componentId, message);
        return this.m_ok;
    }

    @Override
    public TriStatus triSendBC(TriComponentId componentId, TriPortId tsiPortId, TriMessage sendMessage) {
        return this.m_ok;
    }

    @Override
    public TriStatus triSendMC(TriComponentId componentId, TriPortId tsiPortId, TriAddressList addresses, TriMessage sendMessage) {
        return this.m_ok;
    }

    @Override
    public TriStatus triCall(TriComponentId componentId, TriPortId tsiPortId, TriAddress sutAddress, TriSignatureId signatureId, TriParameterList parameterList) {
        return this.m_ok;
    }

    @Override
    public TriStatus triCallBC(TriComponentId componentId, TriPortId tsiPortId, TriSignatureId signatureId, TriParameterList parameterList) {
        return this.m_ok;
    }

    @Override
    public TriStatus triCallMC(TriComponentId componentId, TriPortId tsiPortId, TriAddressList sutAddresses, TriSignatureId signatureId, TriParameterList parameterList) {
        return this.m_ok;
    }

    @Override
    public TriStatus triReply(TriComponentId componentId, TriPortId tsiPortId, TriAddress sutAddress, TriSignatureId signatureId, TriParameterList parameterList, TriParameter returnValue) {
        return this.m_ok;
    }

    @Override
    public TriStatus triReplyBC(TriComponentId componentId, TriPortId tsiPortId, TriSignatureId signatureId, TriParameterList parameterList, TriParameter returnValue) {
        return this.m_ok;
    }

    @Override
    public TriStatus triReplyMC(TriComponentId componentId, TriPortId tsiPortId, TriAddressList sutAddresses, TriSignatureId signatureId, TriParameterList parameterList, TriParameter returnValue) {
        return this.m_ok;
    }

    @Override
    public TriStatus triRaise(TriComponentId componentId, TriPortId tsitPortId, TriAddress sutAddress, TriSignatureId signatureId, TriException exc) {
        return this.m_ok;
    }

    @Override
    public TriStatus triRaiseBC(TriComponentId componentId, TriPortId tsitPortId, TriSignatureId signatureId, TriException exc) {
        return this.m_ok;
    }

    @Override
    public TriStatus triRaiseMC(TriComponentId componentId, TriPortId tsitPortId, TriAddressList sutAddresses, TriSignatureId signatureId, TriException exc) {
        return this.m_ok;
    }

    @Override
    public TriStatus triSutActionInformal(String description) {
        return this.m_ok;
    }

    @Override
    public TriStatus triStaticMap(TriPortId compPortId, TriPortId tsiPortId) {
        return this.m_ok;
    }

    @Override
    public TriStatus triSetStreamValue(TriComponentId componentId, TriPortId tsiPortId, TriAddress SUTaddress, TriMessage streamValue) {
        return this.m_ok;
    }

    @Override
    public TriStatus triGetStreamValue(TriComponentId componentId, TriPortId tsiPortId, TriAddress SUTaddress, TriMessage streamValue) {
        return this.m_ok;
    }

    private void matchFile(UniversalCharstringValue textToMatch, UniversalCharstringValue referenceXmlFile, RecordOfValue xsdFileList, UniversalCharstringValue matchError, UniversalCharstringValue referenceTTCN3File, BooleanValue retValue) {
        String stringToMatch = textToMatch.getString();
        File parentFolder = new File(referenceTTCN3File.getString()).getAbsoluteFile().getParentFile();
        String strReferenceXmlFile = referenceXmlFile.getString();
        strReferenceXmlFile = new File(parentFolder, strReferenceXmlFile).getAbsolutePath();
        String[] xsdFileArray = null;
        if (xsdFileList.getLength() > 0) {
            xsdFileArray = new String[xsdFileList.getLength()];
            int i = 0;
            while (i < xsdFileList.getLength()) {
                xsdFileArray[i] = ((UniversalCharstringValue)xsdFileList.getField(i)).getString();
                ++i;
            }
        }
        String description = null;
        boolean res = false;
        try {
            XmlDiff diff = new XmlDiff(strReferenceXmlFile, xsdFileArray, null);
            StringBuilder sb = new StringBuilder();
            res = diff.diff(stringToMatch, sb);
            if (sb.length() > 0) {
                description = sb.toString();
            }
        }
        catch (Throwable e) {
            description = e.getMessage();
        }
        if (!res && description == null) {
            description = "Unspecified error";
        }
        if (!res) {
            matchError.setString(description);
        }
        retValue.setBoolean(res);
    }

    public void readFile(UniversalCharstringValue referenceXmlFile, UniversalCharstringValue referenceTTCN3File, UniversalCharstringValue res) {
        FileInputStream in = null;
        try {
            try {
                int bytesRead;
                File sReferenceTTCN3File = new File(referenceTTCN3File.getString());
                String strReferenceXmlFile = referenceXmlFile.getString();
                File file = new File(sReferenceTTCN3File.getAbsoluteFile().getParentFile(), strReferenceXmlFile);
                in = new FileInputStream(file);
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                res.setString(out.toString("UTF-8"));
            }
            catch (Throwable e) {
                throw new RuntimeException(MessageFormat.format("error while reading UTF-8 encoded file: {0} {1}", referenceXmlFile.getString(), e.toString()), e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public TriStatus xtriExternalFunction(TriFunctionId functionId, TciParameterList parameterList, Value returnValue) {
        TriStatus status = this.m_ok;
        String funcName = functionId.getFunctionName();
        int index = funcName.indexOf(46);
        if (index >= 0) {
            funcName = funcName.substring(index + 1);
        }
        if (funcName.equals("matchFile")) {
            this.matchFile((UniversalCharstringValue)parameterList.get(0).getParameter(), (UniversalCharstringValue)parameterList.get(1).getParameter(), (RecordOfValue)parameterList.get(2).getParameter(), (UniversalCharstringValue)parameterList.get(3).getParameter(), (UniversalCharstringValue)parameterList.get(4).getParameter(), (BooleanValue)returnValue);
        } else if (funcName.equals("readFile")) {
            this.readFile((UniversalCharstringValue)parameterList.get(0).getParameter(), (UniversalCharstringValue)parameterList.get(1).getParameter(), (UniversalCharstringValue)returnValue);
        } else {
            status = this.m_error;
        }
        return status;
    }
}

