/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class ICSProformaTableGenerator {
    public static Properties config = new Properties();
    public static Properties references = new Properties();
    private ArrayList<File> files = new ArrayList();
    private HashMap<String, ArrayList<ClauseEntry>> clauseMap = new HashMap();

    public void run() {
        System.out.println("STF475 Tools: ICS Proforma Table Generator v0.1");
        try {
            FileUtils.loadConfig(config);
            FileUtils.loadReferences(references);
        }
        catch (IOException e) {
            System.err.println("[ERROR] Cannot load config file or config file is incomplete.");
            return;
        }
        ArrayList<Clause> myList = new ArrayList<Clause>();
        Iterator<Object> it = references.keySet().iterator();
        System.out.println("----");
        while (it.hasNext()) {
            Object value = it.next();
            if (!(value instanceof String)) continue;
            myList.add(new Clause((String)value));
        }
        Collections.sort(myList);
        String atsPath = config.get("ATSPath").toString();
        System.out.println("Gathering files...");
        FileUtils.visitAllFiles(new File(atsPath), this.files);
        System.out.println("Processing files...");
        int i = 0;
        while (i < this.files.size()) {
            File origFile;
            File tempFile = origFile = this.files.get(i);
            T3Purpose purpose = FileUtils.extractPurpose(tempFile);
            T3ExpectedOutput expected = FileUtils.extractExpectedOutput(tempFile);
            ArrayList<ClauseEntry> clauseEntries = this.clauseMap.get(purpose.getClauseStructured().toString());
            if (clauseEntries == null) {
                clauseEntries = new ArrayList();
            }
            ClauseEntry clauseEntry = new ClauseEntry();
            clauseEntry.setFile(tempFile);
            clauseEntry.setPurpose(purpose);
            clauseEntry.setExpected(expected);
            clauseEntries.add(clauseEntry);
            this.clauseMap.put(purpose.getClauseStructured().toString(), clauseEntries);
            ++i;
        }
        try {
            String icsFileHead = FileUtils.loadFileToString(new File("resources/ics-file-head.html"));
            String icsFileFooter = FileUtils.loadFileToString(new File("resources/ics-file-foot.html"));
            String icsSectionHead = FileUtils.loadFileToString(new File("resources/ics-section-head.html"));
            String icsSectionFoot = FileUtils.loadFileToString(new File("resources/ics-section-foot.html"));
            String icsTableRow = FileUtils.loadFileToString(new File("resources/ics-table-line.html"));
            StringBuffer result = new StringBuffer();
            result.append(icsFileHead);
            int tableCounter = 0;
            int sectionCounter = 1;
            int i2 = 0;
            while (i2 < myList.size()) {
                Clause clause = (Clause)myList.get(i2);
                ArrayList<ClauseEntry> clauseEntries = this.clauseMap.get(clause.toString());
                if (clauseEntries != null && clauseEntries.size() > 0) {
                    result.append(this.createSectionHead(icsSectionHead, "A.3." + ++sectionCounter, references.getProperty(clause.toString()), "A." + ++tableCounter));
                    int j = 0;
                    while (j < clauseEntries.size()) {
                        String purposeText = clauseEntries.get(j).getPurpose().getPurposeText();
                        if (purposeText.startsWith("Ensure that")) {
                            String temp;
                            purposeText = purposeText.replaceAll("^Ensure that", "").trim();
                            purposeText = temp = String.valueOf(purposeText.substring(0, 1).toUpperCase()) + purposeText.substring(1);
                        }
                        result.append(this.createTableRow(icsTableRow, j + 1, purposeText, "Clause " + clause, "m", clauseEntries.get(j).getFile().getName().replaceAll("\\.ttcn", "")));
                        ++j;
                    }
                    result.append(icsSectionFoot);
                }
                ++i2;
            }
            result.append(icsFileFooter);
            FileUtils.saveStringToFile(new File(config.get("DeliverableATSPath") + "/stf475-ics.html"), result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("done.");
    }

    private String createTableRow(String tableRow, int number, String purpose, String clause, String status, String tpRef) throws IOException {
        String icsTableRow = tableRow.replaceAll("\\{\\{NUMBER\\}\\}", Integer.toString(number));
        icsTableRow = icsTableRow.replaceAll("\\{\\{PURPOSE\\}\\}", purpose);
        icsTableRow = icsTableRow.replaceAll("\\{\\{CLAUSE\\}\\}", clause);
        icsTableRow = icsTableRow.replaceAll("\\{\\{STATUS\\}\\}", status);
        icsTableRow = icsTableRow.replaceAll("\\{\\{TCTPREF\\}\\}", tpRef);
        return icsTableRow;
    }

    private String createSectionHead(String sectionHead, String targetClause, String clauseDescription, String tableNumber) {
        String icsSectionHead = sectionHead.replaceAll("\\{\\{TARGETCLAUSE\\}\\}", targetClause);
        icsSectionHead = icsSectionHead.replaceAll("\\{\\{CLAUSEDESCRIPTION\\}\\}", clauseDescription);
        icsSectionHead = icsSectionHead.replaceAll("\\{\\{TABLENUMBER\\}\\}", tableNumber);
        return icsSectionHead;
    }

    public static void main(String[] args) {
        new ICSProformaTableGenerator().run();
    }
}

