/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    public static void visitAllFiles(File f, ArrayList<File> files) {
        if (f.isDirectory()) {
            String[] children = f.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.visitAllFiles(new File(f, children[i]), files);
                ++i;
            }
        } else if (f.toString().endsWith(".ttcn") || f.toString().endsWith(".ttcn_")) {
            files.add(f);
        }
    }

    public static void loadConfig(Properties config) throws IOException {
        FileInputStream fis = new FileInputStream("resources/STF475Tools.properties");
        config.load(fis);
        fis.close();
        if (config.get("LogPath") == null || config.get("ATSPath") == null) {
            throw new IOException();
        }
    }

    public static void loadReferences(Properties references) throws IOException {
        FileInputStream fis = new FileInputStream("resources/references.properties");
        references.load(fis);
        fis.close();
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static int countT3Modules(File f) {
        int moduleCount = 0;
        try {
            FileInputStream fs = new FileInputStream(f.getAbsolutePath());
            DataInputStream in = new DataInputStream(fs);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                if (!strLine.matches("^\\s*module\\s+\\w+\\s*.*")) continue;
                ++moduleCount;
            }
            in.close();
            fs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return moduleCount;
    }

    public static T3ExpectedOutput extractExpectedOutput(File f) {
        T3ExpectedOutput t3ExpectedOutput = new T3ExpectedOutput();
        try {
            FileInputStream fs = new FileInputStream(f.getAbsolutePath());
            DataInputStream in = new DataInputStream(fs);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                Matcher matcher;
                if (!strLine.matches("^\\s*\\*+\\s*@verdict\\s*.*") || !(matcher = Pattern.compile("^^\\s*\\*+\\s*@verdict\\s*pass\\s*(.*)").matcher(strLine)).find()) continue;
                String result = matcher.group(1);
                String[] split = result.split(",");
                t3ExpectedOutput.setExpectedOutput(split[0].trim());
                if (split.length <= 1) continue;
                t3ExpectedOutput.setExecutionResult(split[1].trim());
            }
            in.close();
            fs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return t3ExpectedOutput;
    }

    public static T3Purpose extractPurpose(File f) {
        T3Purpose t3Purpose = new T3Purpose();
        try {
            FileInputStream fs = new FileInputStream(f.getAbsolutePath());
            DataInputStream in = new DataInputStream(fs);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                Matcher matcher;
                if (!strLine.matches("^\\s*\\*+\\s*@purpose\\s*.*") || !(matcher = Pattern.compile("^\\s*\\*+\\s*@purpose\\s*(\\d+):(.*?)\\s*,\\s*(.*)").matcher(strLine)).find()) continue;
                String result = matcher.group(1);
                t3Purpose.setPartReference(Integer.parseInt(result));
                result = matcher.group(2);
                t3Purpose.setClause(result);
                result = matcher.group(3);
                t3Purpose.setPurposeText(result);
            }
            in.close();
            fs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return t3Purpose;
    }

    public static ArrayList<File> splitT3ModuleFiles(File f) {
        ArrayList<File> files = new ArrayList<File>();
        StringBuffer current = new StringBuffer();
        File newFile = new File(String.valueOf(f.getParent()) + "//temp.ttcn");
        if (f.exists()) {
            f.renameTo(newFile);
        }
        try {
            FileWriter fw;
            String targetFilename;
            FileInputStream fs = new FileInputStream(newFile.getAbsolutePath());
            DataInputStream in = new DataInputStream(fs);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = "";
            int moduleCounter = 0;
            String currentModuleName = "";
            while ((strLine = br.readLine()) != null) {
                if (strLine.matches("^\\s*module\\s+\\w+\\s*.*")) {
                    Matcher matcher;
                    if (++moduleCounter > 1) {
                        targetFilename = String.valueOf(f.getParent()) + "//" + currentModuleName + ".ttcn";
                        fw = new FileWriter(targetFilename);
                        fw.write(current.toString());
                        fw.close();
                        current = new StringBuffer();
                        files.add(new File(targetFilename));
                    }
                    if ((matcher = Pattern.compile("^\\s*module\\s+(\\w+)\\s*.*").matcher(strLine)).find()) {
                        currentModuleName = matcher.group(1);
                    }
                }
                current.append(String.valueOf(strLine) + "\n");
            }
            targetFilename = String.valueOf(f.getParent()) + "//" + currentModuleName + ".ttcn";
            fw = new FileWriter(targetFilename);
            fw.write(current.toString());
            fw.close();
            in.close();
            fs.close();
            files.add(new File(targetFilename));
            newFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    public static String loadFileToString(File file) throws IOException {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        try {
            int len;
            while ((len = reader.read(chr)) > 0) {
                buffer.append(chr, 0, len);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public static void saveStringToFile(File file, String str) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        out.print(str);
        out.close();
    }
}

