/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DeliverableGenerator {
    private static final String[] IGNORED_FILES = new String[]{".svn", ".git", ".externalToolBuilders", ".settings", "bin", "ttcn3build"};
    private static Set<String> ignoredFiles = new HashSet<String>(Arrays.asList(IGNORED_FILES));
    public static Properties config = new Properties();
    public static Properties references = new Properties();

    public static void generateDeliverableDirectory(File sf, File tf) {
        block6: {
            block5: {
                if (!sf.isDirectory()) break block5;
                File newDir = new File(String.valueOf(tf.getAbsolutePath()) + "/" + sf.getName());
                if (ignoredFiles.contains(sf.getName())) {
                    return;
                }
                newDir.mkdir();
                String[] children = sf.list();
                int i = 0;
                while (i < children.length) {
                    DeliverableGenerator.generateDeliverableDirectory(new File(sf, children[i]), newDir);
                    ++i;
                }
                break block6;
            }
            if (!sf.toString().endsWith(".ttcn")) break block6;
            File newDir = new File(String.valueOf(tf.getAbsolutePath()) + "/" + sf.getName().replaceAll(".ttcn", ""));
            newDir.mkdir();
            try {
                int moduleCount = FileUtils.countT3Modules(sf);
                if (moduleCount <= 1) {
                    File targetFile = new File(newDir + "/" + sf.getName());
                    FileUtils.copyFile(sf, targetFile);
                }
                File targetFile = new File(newDir + "/temp.ttcn");
                FileUtils.copyFile(sf, targetFile);
                FileUtils.splitT3ModuleFiles(targetFile);
                targetFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        System.out.println("STF475 Tools: ATS Deliverable Generator v0.1");
        try {
            FileUtils.loadConfig(config);
            FileUtils.loadReferences(references);
        }
        catch (IOException e) {
            System.err.println("[ERROR] Cannot load config file or config file is incomplete.");
            return;
        }
        String atsPath = config.get("ATSPath").toString();
        String deliverablePath = config.get("DeliverableATSPath").toString();
        File deliverable = new File(deliverablePath);
        deliverable.mkdirs();
        DeliverableGenerator.generateDeliverableDirectory(new File(atsPath), deliverable);
        System.out.println("done.");
    }

    public static void main(String[] args) {
        new DeliverableGenerator().run();
    }
}

