/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AbstractXTriSendMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.ExternalTciValueList;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TciValueRefList;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.xtri.xTriCommunicationSA;

class XTriSendMCMessage
extends AbstractXTriSendMessage {
    private TciValueRefList m_addrList;

    public XTriSendMCMessage() {
        this.m_addrList = new TciValueRefList();
    }

    public XTriSendMCMessage(TriComponentIdImpl comp, TriPortIdImpl systemPort, TciValueRef msg, TciValueRefList addrList) {
        super(comp, systemPort, msg);
        this.m_addrList = addrList;
    }

    public TciValueRefList getAddressList() {
        return this.m_addrList;
    }

    @Override
    protected void serializeAddress(ByteArrayOutputStream ms) {
        this.m_addrList.serialize(ms);
    }

    @Override
    protected void deserializeAddress(ByteArrayInputStream ms) {
        this.m_addrList.deserialize(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.XSendMCMessage;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new XTriSendMCMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() instanceof xTriCommunicationSA;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ExternalTciValue val = this.getMessage().createValue();
        ExternalTciValueList addrList = new ExternalTciValueList(this.m_addrList);
        TriStatus status = ((xTriCommunicationSA)((Object)TriProvider.getInstance().getTriCommunicationSA())).xtriSendMC(this.getComponentId(), this.getSystemPortId(), addrList, val);
        return new AdapterProcessingResult(status);
    }
}

