/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class CoverageLister {
    public static Properties config = new Properties();
    public static Properties references = new Properties();
    public static ArrayList<String> foo = new ArrayList();
    public static HashSet<String> atsDirectories = new HashSet();
    public static ArrayList<File> atsFiles = new ArrayList();
    public static HashSet<String> coveredClauses = new HashSet();

    public String clauseEnhancer(String str) {
        String[] parts = str.split("\\.");
        String composed = "";
        int i = 0;
        while (i < parts.length) {
            try {
                int number = Integer.parseInt(parts[i]);
                composed = String.valueOf(composed) + String.format("%02d", number);
            }
            catch (NumberFormatException e) {
                composed = String.valueOf(composed) + parts[i];
            }
            if (i + 1 < parts.length) {
                composed = String.valueOf(composed) + ".";
            }
            ++i;
        }
        return composed;
    }

    public void run() {
        try {
            FileUtils.loadConfig(config);
            FileUtils.loadReferences(references);
        }
        catch (IOException e) {
            System.err.println("[ERROR] Cannot load config file or config file is incomplete.");
            return;
        }
        String atsPath = config.get("ATSPath").toString();
        System.out.println("Scanning files in " + atsPath + "...");
        FileUtils.visitAllFiles(new File(atsPath), atsFiles);
        int i = 0;
        while (i < atsFiles.size()) {
            atsDirectories.add(atsFiles.get(i).getParentFile().getName());
            ++i;
        }
        for (String entry : atsDirectories) {
            String[] parts = entry.split("_");
            String clause = this.clausePreparer(parts[1]);
            coveredClauses.add(clause);
        }
        for (Map.Entry<Object, Object> entry : references.entrySet()) {
            String str = "";
            str = String.valueOf(str) + this.clauseEnhancer(entry.getKey().toString());
            str = String.valueOf(str) + "\t";
            str = String.valueOf(str) + entry.getValue();
            str = String.valueOf(str) + "\t";
            if (coveredClauses.contains(this.clauseEnhancer(entry.getKey().toString()))) {
                str = String.valueOf(str) + "**covered**";
            }
            foo.add(str);
        }
        Collections.sort(foo);
        System.out.println("Sections not covered by tests, please note that only one section was referenced by a test. There are tests that cover multiple standard sections.");
        int i2 = 0;
        while (i2 < foo.size()) {
            if (!foo.get(i2).contains("**covered**")) {
                System.out.println(foo.get(i2).replaceAll("\\*\\*covered\\*\\*", ""));
            }
            ++i2;
        }
    }

    public String clausePreparer(String str) {
        int index = 0;
        String targetStr = "";
        while (index < str.length()) {
            char prefixChar = str.charAt(index);
            if (prefixChar >= 'A' && prefixChar <= 'E') {
                targetStr = String.valueOf(targetStr) + str.substring(index, index + 1);
                if (++index >= str.length()) continue;
                targetStr = String.valueOf(targetStr) + ".";
                continue;
            }
            targetStr = String.valueOf(targetStr) + str.substring(index, index + 2);
            if ((index += 2) >= str.length()) continue;
            targetStr = String.valueOf(targetStr) + ".";
        }
        return targetStr;
    }

    public static void main(String[] args) {
        new CoverageLister().run();
    }
}

