/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.etsi.mts.ttcn.part9.xmldiff.DiffErrorHandler;
import org.etsi.mts.ttcn.part9.xmldiff.DifferenceHandler;
import org.etsi.mts.ttcn.part9.xmldiff.LogUtil;
import org.etsi.mts.ttcn.part9.xmldiff.XmlDiffError;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDiff {
    public static LogUtil logger = null;
    protected File referenceXmlFile;
    private List<File> xsdFiles;
    private Schema schemes = null;
    private DocumentBuilderFactory xmlParserFactory;
    private DiffErrorHandler errorHandler = new DiffErrorHandler();
    private Document controlDoc;
    private Document testDoc;

    static {
        logger = new LogUtil(Logger.getLogger("org.etsi.mts.ttcn.part9.xmldiff"));
        XmlDiff.logger.logger.setLevel(Level.FINE);
        try {
            FileHandler fh = new FileHandler("XmlDiff.log", true);
            fh.setLevel(Level.FINE);
            XmlDiff.logger.logger.addHandler(fh);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XMLUnit.setIgnoreComments(true);
        XMLUnit.setIgnoreWhitespace(true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA(true);
    }

    public XmlDiff(String referenceXmlFile, String[] xsdFileNames, String[] xsdSearchPath) {
        this(new File(referenceXmlFile), xsdFileNames, xsdSearchPath);
    }

    public XmlDiff(File file, String[] xsdFileNames, String[] xsdSearchPath) {
        logger.debug("Reference file: ", file, ", xsd file names: ", xsdFileNames == null ? "null" : Arrays.toString(xsdFileNames), ", xsd search path: ", xsdSearchPath == null ? "null" : Arrays.toString(xsdSearchPath));
        this.referenceXmlFile = file;
        if (!this.referenceXmlFile.exists()) {
            logger.severe("No such file: ", this.referenceXmlFile.getAbsolutePath());
            throw new IllegalArgumentException("No such file: " + this.referenceXmlFile.getAbsolutePath());
        }
        if (!this.referenceXmlFile.canRead()) {
            logger.severe("Can't read: ", this.referenceXmlFile.getAbsolutePath());
            throw new IllegalArgumentException("Can't read: " + this.referenceXmlFile.getAbsolutePath());
        }
        this.xmlParserFactory = DocumentBuilderFactory.newInstance();
        this.xmlParserFactory.setIgnoringComments(true);
        this.xmlParserFactory.setCoalescing(true);
        this.xmlParserFactory.setIgnoringElementContentWhitespace(true);
        this.xsdFiles = new ArrayList<File>();
        List<String> missing = this.findXsdFiles(xsdFileNames, xsdSearchPath);
        if (missing != null) {
            logger.severe("Missing XSD files " + missing + " in search path " + Arrays.toString(xsdSearchPath));
            throw new IllegalArgumentException("Missing XSD files " + missing + " in search path " + Arrays.toString(xsdSearchPath));
        }
        if (this.xsdFiles.size() > 0) {
            this.addXmlSchemas();
        }
    }

    public boolean diff(String input, StringBuilder diffDetails) throws XmlDiffError {
        FileInputStream stream;
        logger.debug("Looking for difference: reference file ", this.referenceXmlFile, ", input {", input, "}");
        try {
            stream = new FileInputStream(this.referenceXmlFile);
        }
        catch (FileNotFoundException e) {
            logger.severe("File not found: ", this.referenceXmlFile.getAbsolutePath());
            throw new XmlDiffError(e);
        }
        InputStreamReader rd = new InputStreamReader((InputStream)stream, Charset.forName("utf-8"));
        StringReader inputReader = new StringReader(input);
        boolean v = this.diff(rd, inputReader, diffDetails);
        if (!v) {
            logger.info("Compared reference file ", this.referenceXmlFile, " with input {", input, "}, found differences ", diffDetails);
        } else {
            logger.debug("No differences found between reference file ", this.referenceXmlFile, " and input {", input, "}");
        }
        return v;
    }

    boolean diff(Reader input, StringBuilder diffDetails) throws XmlDiffError {
        FileInputStream stream;
        try {
            stream = new FileInputStream(this.referenceXmlFile);
        }
        catch (FileNotFoundException e) {
            throw new XmlDiffError(e);
        }
        InputStreamReader rd = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
        return this.diff(rd, input, diffDetails);
    }

    private boolean diff(Reader expected, Reader actual, StringBuilder diffDetails) throws XmlDiffError {
        boolean result;
        Diff differ = null;
        try {
            differ = this.createDiffer(expected, actual);
        }
        catch (SAXException e) {
            throw new XmlDiffError("Failed to parse XML", e);
        }
        catch (IOException e) {
            throw new XmlDiffError("Failed to read XML", e);
        }
        if (this.errorHandler.hasErrors()) {
            diffDetails.append(this.errorHandler.getErrorsText());
            return false;
        }
        boolean bl = result = differ.identical() || differ.similar();
        if (!result) {
            DetailedDiff details = new DetailedDiff(differ);
            List diffs = details.getAllDifferences();
            if (diffs.isEmpty()) {
                result = true;
            } else {
                for (Difference diff : diffs) {
                    diffDetails.append(diff.toString()).append('\n');
                }
            }
        }
        return result;
    }

    private void addXmlSchemas() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaSources = new Source[this.xsdFiles.size()];
        int i = 0;
        while (i < schemaSources.length) {
            schemaSources[i] = new StreamSource(this.xsdFiles.get(i));
            ++i;
        }
        try {
            this.schemes = schemaFactory.newSchema(schemaSources);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Failed to parse a schema file", e);
        }
        if (this.schemes != null) {
            this.xmlParserFactory.setSchema(this.schemes);
            this.xmlParserFactory.setValidating(false);
            this.xmlParserFactory.setNamespaceAware(true);
        }
    }

    private List<String> findXsdFiles(String[] xsdFileNames, String[] xsdSearchPath) {
        if (xsdFileNames == null || xsdFileNames.length == 0) {
            return null;
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (xsdSearchPath == null || xsdSearchPath.length == 0) {
            String[] stringArray = xsdFileNames;
            int n = xsdFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name == null) {
                    logger.severe("XSD file name is nul!!!");
                } else {
                    logger.debug("Looking for XSD file ", name);
                    File guess = new File(name);
                    if (guess.exists()) {
                        this.xsdFiles.add(guess);
                    } else {
                        missing.add(name);
                    }
                }
                ++n2;
            }
        } else {
            String[] stringArray = xsdFileNames;
            int n = xsdFileNames.length;
            int n3 = 0;
            while (n3 < n) {
                String fileName = stringArray[n3];
                boolean found = false;
                String[] stringArray2 = xsdSearchPath;
                int n4 = xsdSearchPath.length;
                int n5 = 0;
                while (n5 < n4) {
                    String path = stringArray2[n5];
                    File guess = new File(path, fileName);
                    if (guess.exists()) {
                        this.xsdFiles.add(guess);
                        found = true;
                        break;
                    }
                    ++n5;
                }
                if (!found) {
                    missing.add(fileName);
                }
                ++n3;
            }
        }
        return missing.size() > 0 ? missing : null;
    }

    private Document parseXml(Reader inReader, String kind) throws SAXException, IOException, XmlDiffError {
        DocumentBuilder parser;
        logger.debug2("Parse ", kind);
        try {
            parser = this.xmlParserFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.severe("Failed to setup a parser for ", kind, ": ", e.getMessage());
            throw new RuntimeException("Internal error: failed to create an XML parser", e);
        }
        parser.setErrorHandler(this.errorHandler);
        InputSource input = new InputSource(inReader);
        Document result = parser.parse(input);
        if (this.errorHandler.hasErrors()) {
            throw new XmlDiffError("Failed to parse " + kind + ": " + this.errorHandler.getErrorsText());
        }
        return result;
    }

    private Diff createDiffer(Reader control, Reader test) throws SAXException, IOException, XmlDiffError {
        this.controlDoc = this.parseXml(control, "sample XML file");
        this.testDoc = this.parseXml(test, "generated XML document");
        Diff result = new Diff(this.controlDoc, this.testDoc);
        result.overrideDifferenceListener(new DifferenceHandler(this.controlDoc, this.testDoc));
        return result;
    }
}

