/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.ttcn.part9.xmldiff;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.NodeDetail;
import org.etsi.mts.ttcn.part9.xmldiff.XmlDiff;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class DifferenceHandler
implements DifferenceListener {
    private Document originalReference;
    private Document originalTest;
    private XPathFactory xpathFactory;

    public DifferenceHandler(Document originalReference, Document originalTest) {
        this.originalReference = originalReference;
        this.originalTest = originalTest;
        this.xpathFactory = XPathFactory.newInstance();
    }

    @Override
    public int differenceFound(Difference difference) {
        int id = difference.getId();
        if (id == 15) {
            return this.handlePrefixDiff(difference);
        }
        if (id == 14) {
            return this.handleValueDiff(difference);
        }
        if (id == 3) {
            return this.handleValueDiff(difference);
        }
        XmlDiff.logger.debug2("Difference accepted: Namespace prefix ID", difference.getDescription());
        return 0;
    }

    private int handleValueDiff(Difference difference) {
        NodeDetail controlNodeDetail = difference.getControlNodeDetail();
        NodeDetail testNodeDetail = difference.getTestNodeDetail();
        Node originalNode = this.findOriginalNode(controlNodeDetail);
        if (originalNode == null) {
            return 0;
        }
        if (this.isFloat(originalNode)) {
            return this.handleFloat(controlNodeDetail, testNodeDetail);
        }
        return 0;
    }

    private int handleFloat(NodeDetail controlNodeDetail, NodeDetail testNodeDetail) {
        String controlValue = controlNodeDetail.getValue();
        double controlDouble = 0.0;
        try {
            controlDouble = Double.parseDouble(controlValue);
        }
        catch (NumberFormatException err) {
            XmlDiff.logger.severe("Failed to convert reference value to double {", controlValue, "}: error ", err.getMessage());
            return 0;
        }
        String testValue = testNodeDetail.getValue();
        double testDouble = 0.0;
        try {
            testDouble = Double.parseDouble(testValue);
        }
        catch (NumberFormatException err) {
            XmlDiff.logger.severe("Failed to convert test value to double {", testValue, "}: error ", err.getMessage());
            return 0;
        }
        if (testDouble == controlDouble) {
            XmlDiff.logger.debug("Compare {", controlValue, "} and {", testValue, "}: identical");
            return 1;
        }
        XmlDiff.logger.debug("Compare {", controlValue, "} and {", testValue, "}: different");
        return 0;
    }

    private Node findOriginalNode(NodeDetail nodeDetail) {
        String controlXpath = DifferenceHandler.fixXpath(nodeDetail.getXpathLocation());
        XPath xpath = this.xpathFactory.newXPath();
        Node result = null;
        try {
            result = (Node)xpath.evaluate(controlXpath, this.originalReference, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            XmlDiff.logger.severe("Failed to process XPATH expression '", controlXpath, "': error " + e.getMessage());
            return null;
        }
        if (result == null) {
            XmlDiff.logger.severe("Nothing found by XPATH expression '", controlXpath, "'");
        }
        return result;
    }

    private boolean isFloat(Node node) {
        TypeInfo typeinfo;
        boolean isFloat = false;
        if (node.getNodeType() == 3) {
            node = node.getParentNode();
        }
        if ((typeinfo = DifferenceHandler.guessTypeInfo(node)) == null) {
            XmlDiff.logger.info("No type info found: node ", node.getNodeName());
            return false;
        }
        isFloat = typeinfo.isDerivedFrom("http://www.w3.org/2001/XMLSchema", "float", 1) || typeinfo.isDerivedFrom("http://www.w3.org/2001/XMLSchema", "float", 2);
        XmlDiff.logger.debug2("isFloat == ", isFloat, ": type ", typeinfo.getTypeName(), ", node ", node.getNodeName());
        return isFloat;
    }

    private int handlePrefixDiff(Difference difference) {
        XmlDiff.logger.debug3("Difference ignored: Namespace prefix ID", difference.getDescription());
        return 1;
    }

    @Override
    public void skippedComparison(Node control, Node test) {
    }

    private static String fixXpath(String orig) {
        String result = orig.replaceAll("/([a-zA-Z0-9_-]+)(\\[[0-9]+\\](/|$))?", "/*[local-name()='$1']$2");
        XmlDiff.logger.debug2("Original xpath: {", orig, "}, modified: {", result, "}");
        return result;
    }

    private static TypeInfo guessTypeInfo(Node node) {
        TypeInfo typeinfo = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            typeinfo = element.getSchemaTypeInfo();
        }
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            typeinfo = attr.getSchemaTypeInfo();
        }
        return typeinfo;
    }
}

